<?php
    include_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/sessionStartGeneral.php");
?>

<?php
$pageTitle = "Fuel Rewards FAQ";
$pageDescription = "Frequently Asked Questions Fuel Rewards";
$pageKeywords = "Thayne, Wyoming, grocery, store, market, fresh foods, Wyoming, grocery, Valley Market Thayne, grocery store";

$theSiteParts = explode(".", $_SERVER['HTTP_HOST']);
$theSite = $theSiteParts[0];
?>
<?php
    include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php");
?>

<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/mainNav.php'); ?>

<style>
@media only screen and (max-width: 768px) {

    html,
    body {
        height: 100% !important;
        width: 100% !important;
        display: contents !important;
        /* padding-left: 5px !important; */
        /* margin: 5px !important; */
        padding-right: 5px !important;
    }

    .alignButtons {
        text-align: center;
    }

    .wrapper {
        max-width: 100% !important;
        /* margin: 10px auto 0 auto !important; */
        margin: auto;
        margin-left: 10px;
        display: block !important;
        padding: 15px !important;
    }

    #howItWorks-img1 {
        margin-bottom: 10px;
    }

    #howItWorks-row {
        margin: 0px;
        padding: 0px;
        text-align: left;
    }

    /*     .wrapper {
        display: grid;
        grid-gap: 1em;
        grid-template-areas:
            "hero"
            "howItWorks"
            "getStarted"
            "pointsBreakdown"
            "howToRedeemPoints";
    } */
}


@media only screen and (min-width: 768px) {

    html,
    body {
        height: 100% !important;
        width: 90% !important;
        display: contents !important;
        padding-left: 20px !important;
        margin: 20px;
    }


    .row {
        display: flex;
        flex-direction: row;
        flex-wrap: wrap;
        width: 90%;
        /*  justify-content:center;
        text-align:center; */
    }

    .column {
        display: flex;
        flex-direction: column;
        flex-basis: 100%;
        flex: 1;
        align-item: center;
    }


    .column-2 {
        flex: 40%;
        max-width: 40%;
        max-height: 100px;
        padding: 0 4px;
        /* justify-content: flex-start; */
        /* margin-left: 20px; */
    }

    .column-2 img {
        margin-top: 8px;
        vertical-align: middle;
        width: 100%;
        margin-left: 50px;
    }

    .wrapper {

        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        -webkit-box-orient: vertical;
        -webkit-box-direction: normal;
        -ms-flex-direction: column;
        flex-direction: column;
        margin-left: 50px;

    }

    /*  #hero-img {
        margin-left: 50px;
        height: 200px;
    } */

    #hero-img {
        /* margin-left: 10px !important; */
        height: 200px;
        max-width: 800px !important;
        /* width: 800px !important; */
        /* padding-right: 30px !important; */
        /* margin-right: 30px !important; */
    }


    #imgFuelPoints {
        max-height: 180px;
    }

    .aligner-center {
        display: flex;
        /* align-items: center; */
        /* min-height: 24em; */
        height: 20px;
        justify-content: center;
    }

    .aligner-item {
        flex: 1;
    }

    .aligner-item--top {
        align-self: flex-start;
    }

    .aligner-item--bottom {
        align-self: flex-end;
    }

    .aligner-item--fixed {
        flex: none;
        max-width: 50%;
    }


    .box {
        /* background-color: #444; */
        /* color: #fff; */
        border-radius: 5px;
        padding: 10px;
        /*font-size: 150%;*/
    }


    li {
        list-style: none;
    }
}

.box {
    /*  background-color: #444;
    color: #fff; */
    border-radius: 5px;
    padding: 10px;
    /*font-size: 150%;*/
}

.hero,
.howToRedeemPoints {
    /* background-color: #999; */
}

.getStarted {
    /* background-color: #ccc;
    color: #444; */
}

li {
    list-style: none;
}

.alignButtons {
    align-self: center;
    /*padding-right: 100px;*/
}
</style>

<div class="wrapper">
    <div class="box row" style="text-align:center; display:block; margin-left:5px;">
        <div class="column">
            <img src="/Kickstrap/img/ValleyMarket_FuelSiteGraphicsFuelRewards_Header.jpg"
                alt="Fuel Rewards Header image" id="hero-img">
        </div>
    </div>

    
    <div class="box row">
        <div class="column">
            <h1 style="color:#f79e1e;">How It Works</h1>
            <p>It’s easy to start earning money towards savings on fuel.
                Every dollar spent at our location earns 1 rewards point. For every 50 points
                spent,
                you’ll receive .05 off per gallon good for one fill up of up to 35 gallons. To earn points, provide your
                phone number at checkout every time you shop.
                To track your points, log into your account.
            </p>
        </div>
    </div>

    <div class="box row" style="text-align:center;">

        <div class="column-2" style="margin-right: 20px; margin-left: 20px;">
            <img src="/Kickstrap/img/ValleyMarket_FuelSiteGraphicsPointsGraphic_HRZ.jpg" alt="point graphics"
                id="howItWorks-img1">
        </div>
        <div class="column-2" style="margin-left: 20px;">
            <img src="/Kickstrap/img/ValleyMarket_FuelSiteGraphics_CarGraphics.png" alt="car graphics"
                id="howItWorks-img2">
        </div>

    </div>


    <div class="row">
        <h1 style="color:#f79e1e; margin-left:10px;">Get Started</h1>
    </div>

    <div class="box row">
        <div class="column">
            <ul>
                <h4>New To Rewards?</h4>
                <i>Follow the steps below to start earning towards fuel today.</i>
                <li> 1. Complete the registration form <b><a style="color:red;" href="/register.php">here</a></b>.
                </li>
                <li> 2. Shop for groceries at our store.</li>
                <li> 3. Provide your phone number every time you checkout to start earning points. </li>
                <li> 4. Once you’ve earned 50 points, visit our fuel station to use your .05¢ discount. </li>
                <li> 5. Be sure to use your credit before it expires, reference the chart below. </li>
            </ul>
        </div>
        <div class="column">

            <ul>
                <h4>Already a member?</h4>
                <i>Follow these steps to switch to Fuel Rewards.</i>
                <li> 1. Log into your account page <b><a style="color:red;" href="/login.php">here</a></b>.</li>
                <li> 2. Under My Account, My Rewards, select Fuel under the dropdown. </li>
                <li> 3. Shop for groceries at our store.</li>
                <li> 4. Provide your phone number every time you checkout to start earning points. </li>
                <li> 5. Once you’ve earned 50 points, visit our fuel station to use your .05¢ discount. </li>
                <li> 6. Be sure to use your credit before it expires, reference the chart below </li>
            </ul>
        </div>

    </div>


    <div class="box row">
        <h1 style="color:#f79e1e;">Points breakdown</h1>
    </div>

    <div class="box row">
        <div class="column">
            <p>Fuel Points Breakdown</p>
            <img src="/Kickstrap/img/ValleyMarket_FuelSiteGraphics_FuelPointsGraphic.png" alt="Fuel Points Graphic"
                id="imgFuelPoints">
            <br>
            <p>Maximum $1.00 off per gallon</p>
        </div>
    </div>

    <div class="box row" id="howItWorks-row">
        <h1 style="color:#f79e1e;">How to redeem</h1>
    </div>

    <div class="box row">
        <div class="column">
            <p>
                To redeem your fuel discount simply use your Rewards phone number at
                the pump and
                indicate you would like to use your credit. Discounts must be redeemed by the end of the month following
                the
                month in which
                the points were earned.
            </p>
        </div>

    </div>

    <?php
    if($loggedIn === false){
    ?>
    <div class="box row aligner-center" style="text-align:center;">
        <span><a href="/register.php" class="btn btn-primary" style="width:100px; margin-right: 10px;">Register</a></span>
        <span><a href="/login.php" class="btn btn-primary" style="width:100px;">Log In</a></span>
    </div>
    <?php 
    } else {
    ?>
  <!--   <div class="box row aligner-center" style="text-align:center;">
        <span><a href="/register.php" class="btn btn-primary" style="width:100px;">Register</a></span>
        <span><a href="/login.php" class="btn btn-primary" style="width:100px;">Log In</a></span>
    </div> -->
    <?php 
    } 
    ?>

</div>

<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>