<?php	
	/**
	 * Handles user interactions within the app
	 *
	 * PHP version 5
	 */
	require_once('constants.inc.php');
	
	class connector{
		public $_db;
		
		/**
		 * Creates a db object if it isn't already set
		 *
		 * @param object $db
		 * @return void
		 */
		public function __construct(){
			$dsn = "mysql:host=".DB_HOST.";dbname=".DB_NAME;
			$this->_db = new PDO($dsn, DB_USER, DB_PASS);
			$this->setOffset();
			
			//$this->_db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			//$this->_db->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
		}
		
		public function setOffset(){
			date_default_timezone_set("America/Denver");
			
			$now = new DateTime();
			$mins = $now->getOffset() / 60;
			$sgn = ($mins < 0 ? -1 : 1);
			$mins = abs($mins);
			$hrs = floor($mins / 60);
			$mins -= $hrs * 60;
			$offset = sprintf('%+d:%02d', $hrs*$sgn, $mins);
			
			$this->_db->exec("SET time_zone='$offset';");
		}
	}
?>
