<script>
	var theUserInfo = {};
	
	window.addEventListener('message', receiver, false);
	
	function receiver(e){
	  if(e.origin == 'https://maceysps.accelitec.com'){
		var theData = $.parseJSON(e.data);
		var theEvent = theData.event;
		
		//alert(theData);
		
		//when the page is loaded within the iFrame
		if(theEvent == "ready"){
		  $("#rewardsFrame").attr("height", (theData.data.height + 20));
		  
		  if(theData.data.pathname.indexOf("Secure") >= 0 ){
			$("#walletAlert").addClass("hideObject");
		  }else{
			$("#walletAlert").removeClass("hideObject");
		  }
		}
		
		//when a user logs-in to member connect
		if(theEvent == "user"){
			if(theData.action == "login"){
				theUserInfo['name'] = theData.data.Identification[0].Firstname;
				theUserInfo['email'] = theData.data.Identification[0].EmailAddress;
				theUserInfo['xRef'] = theData.XRef;
				//console.log(theData);
				
				$.ajax({
					type: "POST",
					url: "/admin/lookUp.php",
					data: "action=checkUserStatus&useremail=" + theData.data.Identification[0].EmailAddress,
					dataType: "json",
					success: function(theResponse){
						if(theResponse['status'] == false){
							if(theResponse['message'] == "No user associated"){
								var theHTML = "";
								theHTML += "<div class='alert'>";
								theHTML += "<h5>You do not have a website account at Thayne Valley Market.</h5>";
								theHTML += "<p class='btn-group'>";
								theHTML += "<span id='createAccount' class='btn btn-primary'>Create an account</span>";
								theHTML += "<span id='noAccount' class='btn'>I don't want an account</span>";
								theHTML += "</p>";
								theHTML += "</div>";
								theHTML += "<br><br>";
							}else if(theResponse['message'] == ""){
								
							}
							
							$("#communicationHolder").html(theHTML);
						}else{
							var theHTML = "";
							if(theResponse['message'] == "Linked to rewards"){
								theHTML = "<h5>You have been signed into Thayne Valley Market as well.</h5><br><br>";
								setTimeout(function(){
									$("#communicationHolder").html("");
								},3500);
							}else if(theResponse['message'] == "Not linked to rewards"){
								theHTML += "<div class='alert'>";
								theHTML += "<h5>You have a website account at Thayne Valley Market, but it is not linked to your rewards account.<br>Do you want to link the accounts?</h5>";
								theHTML += "<p class='btn-group'>";
								theHTML += "<span id='linkAccount' class='btn btn-primary'>Link the accounts</span>";
								theHTML += "<span id='noAccount' class='btn'>Don't link the accounts</span>";
								theHTML += "</p>";
								theHTML += "</div>";
								theHTML += "<br><br>";
							}
							$("#communicationHolder").html(theHTML);
						}
					}
				});
			}
		}
		
		if(theEvent == "shoppingList"){
			if(theData.action == "add"){
				$.ajax({
					type: "POST",
					url: "/admin/lookUp.php",
					data: "action=checkForRewardList&userEmail=" + theUserInfo['email'],
					dataType: "json",
					success: function(theResponse){
						var theHTML = "";
						if(theResponse['status'] == true){
							var userID = theResponse['userId'];
							var listID = theResponse['listId'];
							addItemToList(theData.data.ShoppingListItem[0], listID);
							/**/
						}else{
							var userID = theResponse['userId'];
							$.ajax({        
								type: "POST",
								url: "/admin/lookUp.php",
								data: { action: "newListAccelitec", userID : userID, rewardsList : true },
								success: function(listResponse) {
									var listID = listResponse['listID'];
									if(listResponse['status'] == true){
										addItemToList(theData.data.ShoppingListItem[0], listID);
									}else{
										
									}
								}
							});
						}
					}
				});
			}
		}
	  }
	}
	
	function addItemToList(theItem, theListID){
		//console.log(theListID);
		
		var theList = {theItem: {itemQty: theItem['Quantity'], altText: theItem['ProductDescription'], itemId: 999}};
		
		$.ajax({        
			type: "POST",
			url: "/admin/lookUp.php",
			data: { action: "addItemRewards", list : theList, listID : theListID },
			success: function(listResponse) {
				console.log("Item added to the list");
			}
		});
	}
	
	$(document.body).on("click", "#createAccount", function(){
		//console.log("create the account for " + theUserInfo['email']);
		var userInfoToSend = convertArray(theUserInfo);
		$.ajax({
			type: "POST",
			url: "/admin/lookUp.php",
			data: "action=createAccountFromAccelitec" + userInfoToSend,
			dataType: "json",
			success: function(theResponse){
				var theHTML = "";
				if(theResponse['status'] == false){
					if(theResponse['message'] == "This user already exists"){
						theHTML += "<div class='alert'>";
						theHTML += "<h5>There is a user already associated with <b>" + theUserInfo['email'] + "</b></h5>";
						theHTML += "</div>";
					}else if(theResponse['message'] == "Execution failed"){
						theHTML += "<div class='alert'>";
						theHTML += "<h5>The user could not be created.</h5>";
						theHTML += "</div>";
					}
				}else{
					if(theResponse['message'] == "User was created"){
						theHTML += "<div class='alert alert-success'>";
						theHTML += "<h5>" + theUserInfo['email'] + " had an account created!</h5>";
						theHTML += "</div>";
					}
				}
				
				$("#communicationHolder").html(theHTML);
				setTimeout(function(){
					$("#communicationHolder").html("");
				},3500);
			}
		});
	});
	
	$(document.body).on("click", "#linkAccount", function(){
		var userInfoToSend = convertArray(theUserInfo);
		$.ajax({
			type: "POST",
			url: "/admin/lookUp.php",
			data: "action=linkUserRewards" + userInfoToSend,
			dataType: "json",
			success: function(theResponse){
				var theHTML = "";
				if(theResponse['status'] == false){
					if(theResponse['message'] == "Execution failed"){
						theHTML += "<div class='alert'>";
						theHTML += "<h5>The link could not be made.</h5>";
						theHTML += "</div>";
					}
				}else{
					if(theResponse['message'] == "Successfully linked"){
						theHTML += "<div class='alert alert-success'>";
						theHTML += "<h5>The link was made successfully!</h5>";
						theHTML += "</div>";
					}
				}
				
				$("#communicationHolder").html(theHTML);
				setTimeout(function(){
					$("#communicationHolder").html("");
				},3500);
			}
		});
	});
	
	$(document.body).on("click", "#noAccount", function(){
		$("#communicationHolder").html("");
		
		setTimeout(function(){
			$("#communicationHolder").html("");
		},2500);
	});
	
	function convertArray(theItem){
		var theString = "";
		$.each(theItem, function(title, value){
			theString += "&" + title + "=" + value;
		});
		
		return theString;
	}
</script>