<?php
	//THIS FILE HANDLES ALL OF THE INTERACTIONS WITHIN THE SITE ON PUBLIC PAGES THAT ARE CALLED THROUGH AJAX
	
	header('Content-type: application/json');
	require_once('inc/constants.inc.php');
	require_once('inc/class.features.inc.php');
	require_once('inc/class.users.inc.php');
	require_once('inc/class.recipes.inc.php');
	require_once('inc/class.brdata.inc.php');
	
	$storeObj = new stores();
	$userObj = new users();
	$recipeObj = new recipes();
	$brdataObj = new brdata();
	
	if(!empty($_POST['action'])){
		
		switch($_POST['action']){
			case 'getFeatures':
				$update = $storeObj->getCurrentFeatures();
				echo json_encode($update);
				break;
		    case "getLunchDay":
				$update = $storeObj->getLunchDay($_POST['date'], isset($_POST['deliType']) ? $_POST['deliType'] : false);
				echo json_encode($update);
				break;
		    case "getLunchWeek":
				$update = $storeObj->getLunchWeek($_POST['startDate'], $_POST['endDate']);
				echo json_encode($update);
				break;
			case "getFeatRecipe":
				$theReturn = $recipeObj->getFeaturedRecipe();
				echo json_encode($theReturn);
				break;
			case "getRecipe":
				$theReturn = $recipeObj->getRecipeByID($_POST['recipeID']);
				echo json_encode($theReturn);
				break;
			case "getMonthFeaturedRecipe":
				$theReturn = $recipeObj->getMonthFeaturedRecipe($_POST['theDate']);
				echo json_encode($theReturn);
				break;
			case "getDeliItems":
				$theReturn = $storeObj->getDeliItems();
				echo json_encode($theReturn);
				break;
			case "newList":
				$theReturn = $userObj->newList($_POST['userID']);
				break;
			case "newListAccelitec":
				$theReturn = $userObj->newList($_POST['userID'], $_POST['rewardsList']);
				echo json_encode($theReturn);
				break;
			case "saveListName":
				$theReturn = $userObj->saveListName($_POST['listName'], $_POST['listNum']);
				echo json_encode($theReturn);
				break;
			case "deleteList":
				$theReturn = $userObj->deleteList($_POST['listNum']);
				echo json_encode($theReturn);
				break;
			case "addItemRewards":
				$theReturn = $userObj->saveList($_POST['list'], $_POST['listID'], true);
				break;
			case "changeLocation":
				$theReturn = $userObj->changeLocation($_POST['newLocation'], $_POST['userName']);
				echo json_encode($theReturn);
				break;
			case "getStoreLocations":
				$theReturn = $userObj->getAllStoreLocations();
				echo json_encode($theReturn);
				break;
			case "saveList":
				$theReturn = $userObj->saveList($_POST['list'], $_POST['listID']);
				echo json_encode($theReturn);
				break;
			case "checkUserStatus":
				$theReturn = $userObj->accountCheckAccelitec();
				echo json_encode($theReturn);
				break;
			case "checkForRewardList":
				$theReturn = $userObj->checkForRewardList($_POST['userEmail']);
				echo json_encode($theReturn);
				break;
			case "linkUserRewards":
				$theReturn = $userObj->linkAccelitecAccount();
				echo json_encode($theReturn);
				break;
			case "createAccountFromAccelitec":
				$theReturn = $userObj->createAccountFromAccelitec();
				echo json_encode($theReturn);
				break;
			case "itemsByStore":
				$theReturn = $storeObj->getDirectoryItemsStore($_POST['location']);
				echo json_encode($theReturn);
				break;
			case "getBlacklisted":
				$theReturn = $storeObj->getAllBlacklisted();
				echo json_encode($theReturn);
				break;
			case "getFacebookWall":
				//if(isset($_POST['data'])){
				//	echo "<pre>";
				//	var_dump($_POST['data']);
				//	echo "</pre>";
				//	exit;
				//}
				$theReturn = $storeObj->getFacebookWall($_POST['location'], isset($_POST['data']) ? $_POST['data'] : null);
				echo json_encode($theReturn);
				break;
				case "changeBrPW":
				$theReturn = $brdataObj->updatePassword($_POST);
				echo json_encode($theReturn);
				break;
			case "loginBR":
				$theReturn = $brdataObj->accountLogin($_POST);
				echo json_encode($theReturn);
				break;
			case "changePasswordRequest":
				$theReturn = $brdataObj->verifySecurity();
				$httpsVersion = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off' ? 'https' : 'http';
				
				if(isset($theReturn['Success']) && $theReturn['Success'] === "true"){
					header("Location: " . $httpsVersion . "://" . $_SERVER['SERVER_NAME'] . "/login?resetRequest=true");
				}else if(isset($theReturn['reason']) && isset($theReturn['errorCode'])){
					header("Location: " . $httpsVersion . "://" . $_SERVER['SERVER_NAME'] . "/login?resetRequest=false&reason=" . urlencode($theReturn['reason']));
				}else{
					header("Location: " . $httpsVersion . "://" . $_SERVER['SERVER_NAME'] . "/login?resetRequest=false");
				}
				break;
			case "updateSecurityInfo":
				$httpsVersion = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off' ? 'https' : 'http';
				
				$theReturn = $brdataObj->updateSecurity($_POST['frequentshoppernum'], $_POST['securityquestion'], $_POST['securityanswer']);
				
				echo json_encode($theReturn);
				
				break;
			case "addSecondaryUser":
				$theReturn = $brdataObj->addSecondaryUser();
				echo json_encode($theReturn);
				break;
			case "updateSecondaryUser":
				$theReturn = $brdataObj->updateSecondaryUser();
				echo json_encode($theReturn);
				break;
			case "deleteSecondaryUser":
				$theReturn = $brdataObj->deleteSecondaryUser();
				echo json_encode($theReturn);
				break;
			case "changeBrEmailOptIn":
				$theReturn = $brdataObj->updateEmailSubscription(json_decode($_POST['subscription']), $_POST['email']);
				echo json_encode($theReturn);
				break;
			case "changeBrCharity":
				$theReturn = $brdataObj->updateUserCharity($_POST['charity']);
				//$theReturn = $brdataObj->updateUser();
				echo json_encode($theReturn);
				break;
			case "cacheBlogPosts":
				$theReturn = $storeObj->cacheBlogPosts($_POST['fileName'],isset($_POST['data']) ? $_POST['data'] : null);
				echo json_encode($theReturn);
				break;
			default:
				echo "No action sent";
				break;
		}
		
		
	}else if(!empty($_GET['action'])){
		switch($_GET['action']){
			case "dirSearch":
				$update = $storeObj->directorySearch($_GET['term'], $_GET['storeNum']);
				echo json_encode($update);
				break;
			case "getCurrentEvents":
				$numDays = 7;
				$update = $storeObj->getCurrentEvents($numDays);
				echo json_encode($update);
				break;
			default:
				echo "No action sent";
				break;
		}
	}
?>