<?php
  if(!isset($_SESSION)){
	session_start();
  }

    include_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/sessionStartGeneral.php");
?>

<?php
$pageTitle = "Thayne Valley Market Receipts page";
$pageDescription = "Thayne Valley customer's receipts summary and details";
$pageKeywords = "Thayne, Wyoming, grocery, store, market, fresh foods, Wyoming, grocery, Valley Market Thayne, grocery store";

$theSiteParts = explode(".", $_SERVER['HTTP_HOST']);
$theSite = $theSiteParts[0];
?>


<?php  
if(isset($loggedIn) && $loggedIn === true)
{
    include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php");
    require($_SERVER['DOCUMENT_ROOT'] . '/common/mainNav.php');
    require_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/class.brdata.inc.php");
    $brdataObj = new brdata();
    
    $theUser = [];
    $customerReceipts = [];

    require_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/class.rewards.inc.php");

    $theUser = $brdataObj->getUser($_SESSION['FrequentShopperNum']);
	$rewardsUserObj = new rewards($theUser['Phone']);

    $rewardsReceipts = $rewardsUserObj->getUserOrderSummary();

    $receiptCounter = 0;      
	  
        $receiptsHTML = "";
        $url = "#";
        $anchorStart = "<a href='#' class='receiptLink'>";
        $siteName = "";
		$anchorTagID = "";
        $anchorEnd = " </a> <br> <span> ";
        $transactionDate = "";
        $amount = 15.49;
        $transactionAmount = ""; 
        $transactionID = "";
        $divID = "";
        $receiptLinkID = "";
        $formatDate = "";
        $htmlEnd = " </span> <br> ";
        $receiptsLinkOpenDiv = "";
        $receiptsLinkCloseDiv = "";
    
        //$rewardsReceipts foreach loop to generate option tag HTML markup
        if(!isset($rewardsReceipts['error'])){
        foreach($rewardsReceipts as $rewardReceipt)
        {
            // $receiptsHTML .= '<option value="' . $rewardReceipt['TransactionID'] . '">' . $rewardReceipt['SiteName'] . ' - ' . date("m/d/Y H:i:s", strtotime($rewardReceipt['TransactionDate'])) .  '-' . number_format($receipt['Amount'], 2).'</option>';
            $receiptCounter++;
            $siteName = $rewardReceipt['SiteName'];        
            $transactionDate = $rewardReceipt['TransactionDate']; 
            $formatDate = date("m/d/Y H:i:s", strtotime($transactionDate));
            $transactionAmount = '$' . number_format($rewardReceipt['Amount'], 2); 
            $anchorTagID = "myBtn_".$rewardReceipt['TransactionID'];
            $transactionID = $rewardReceipt['TransactionID'];
            $receiptLinkID = 'receiptLink_'.$transactionID;
            $initialClass = 'class="highlightDiv receiptLinkContainer receiptsLink clearfix"';
            $remainingClasses = 'class="receiptLinkContainer receiptsLink clearfix"';            

            $divID = 'id=receiptLink_' .$rewardReceipt['TransactionID']. "'";
            if ($receiptCounter == 1) {
                $receiptsLinkOpenDiv = "<div '".$initialClass."' '" .$divID."'>' " ;                
            } else {
                $receiptsLinkOpenDiv = "<div '".$remainingClasses."' '" .$divID."'>' " ;  
            }        

            $receiptsLinkCloseDiv = "</div> \r\n" ;
            
			$receiptsHTML .=  $receiptsLinkOpenDiv;
            $receiptsHTML .= "<span><a onclick=highlightDiv('".$receiptLinkID. "'); href=#receiptsModal class='receiptLink' id='".$anchorTagID."'>" .$siteName. "</a> </span> <span style=float:'right'> '".$transactionAmount. "'</span> <br> <span>'".$formatDate."' </span> <br>";
            //$receiptsHTML .= "<span><a href=#receiptsModal class='receiptLink' id='myBtn'>" .$siteName. "</a> &nbsp; &nbsp; '".$transactionAmount. "'<br> '".$formatDate."' </span> <br>";
			$receiptsHTML .= $receiptsLinkCloseDiv;
			
            }
        }
    else {
	
		//one sample record
            $receiptCounter++;
            $siteName = "My Site Name";        
            $transactionDate = "2019-08-25T23:55:31+00:00";
            $formatDate = date("m/d/Y H:i:s", strtotime($transactionDate));
            $transactionAmount  = '$'.$amount;
            $url = "onclick=popup('/includes/receiptDetails.php')";
            $divID = "id='receiptLink_".$receiptCounter."'";
            $receiptDetailsID = $divID;
            $transactionID = $receiptCounter;
            $receiptLinkID = 'receiptLink_'.$transactionID;
            $receiptsLinkOpenDiv = "<div class='highlightDiv receiptLinkContainer receiptsLink clearfix' ".$divID." '> <br>' " ;
            $receiptsLinkCloseDiv = '</div>;';
			$anchorTagID = "myBtn_".$receiptCounter;
            
            $receiptsHTML .=  $receiptsLinkOpenDiv;
            $receiptsHTML .= "<span><a onclick=highlightDiv('".$receiptLinkID. "'); href=#receiptsModal class='receiptLink' id='".$anchorTagID."'>" .$siteName. "</a> </span> <span style=float:'right'> '".$transactionAmount. "'</span> <br> <span>'".$formatDate."' </span> <br>";
            //$receiptsHTML .= "<span><a href=#receiptsModal class='receiptLink' id='".$anchorTagID."'>" .$siteName. "</a> </span> <span style=float:'right'> '".$transactionAmount. "'</span> <br> <span>'".$formatDate."' </span> <br>";
			// $receiptsHTML .= "<span><a href=#receiptsModal class='receiptLink' id='".$anchorTagID."'>" .$siteName. "</a> &nbsp; &nbsp; &nbsp; &nbsp; '".$transactionAmount. "'<br> '".$formatDate."' </span> <br>";
            //$receiptsHTML .= "<span><a href=#receiptsModal class='receiptLink' id='myBtn'>" .$siteName. "</a> &nbsp; &nbsp; '".$transactionAmount. "'<br> '".$formatDate."' </span> <br>";
            //$receiptsHTML .= "<span><a href=#receiptsModal class='receiptLink' id='myBtn'>" .$siteName. "</a> &nbsp; &nbsp; '".$transactionAmount. "'<br> '".$formatDate."' </span> <br>";
            $receiptsHTML .= $receiptsLinkCloseDiv;
            
			//2nd sample record
			$receiptCounter++;
            $siteName = "My Site Name";        
            $transactionDate = "2019-08-31T11:55:31+00:00";
            $formatDate = date("m/d/Y H:i:s", strtotime($transactionDate));
            $transactionAmount  = '$'.$amount;
            $url = "onclick=popup('/includes/receiptDetails.php')";
            $divID = "id='receiptLink_".$receiptCounter."'";
            $transactionID = $receiptCounter;
            $receiptLinkID = 'receiptLink_'.$transactionID;
            $receiptsLinkOpenDiv = "<div class='receiptLinkContainer receiptsLink clearfix' ".$divID." '> <br>' " ;
            $receiptsLinkCloseDiv = '</div>;';
			$anchorTagID = "myBtn_".$receiptCounter;
            
            $receiptsHTML .=  $receiptsLinkOpenDiv;
            $receiptsHTML .= "<span><a onclick=highlightDiv('".$receiptLinkID. "'); href=# class='receiptLink' id='".$anchorTagID."'>" .$siteName. "</a> </span> <span style=float:'right'> '".$transactionAmount. "'</span> <br> <span>'".$formatDate."' </span> <br>";
            // $receiptsHTML .= "<span><a href=#receiptsModal class='receiptLink' id='".$anchorTagID."'>" .$siteName. "</a> </span> <span style=float:'right'> '".$transactionAmount. "'</span> <br> <span>'".$formatDate."' </span> <br>";
			// $receiptsHTML .= "<span><a href=#receiptsModal class='receiptLink' id='".$anchorTagID."'>" .$siteName. "</a> &nbsp; &nbsp; &nbsp; &nbsp; '".$transactionAmount. "'<br> '".$formatDate."' </span> <br>";
            //$receiptsHTML .= "<span><a href=#receiptsModal class='receiptLink' id='myBtn'>" .$siteName. "</a> &nbsp; &nbsp; '".$transactionAmount. "'<br> '".$formatDate."' </span> <br>";
            //$receiptsHTML .= "<span><a href=#receiptsModal class='receiptLink' id='myBtn'>" .$siteName. "</a> &nbsp; &nbsp; '".$transactionAmount. "'<br> '".$formatDate."' </span> <br>";
            $receiptsHTML .= $receiptsLinkCloseDiv;
    }
}
    else{

        if ($_SERVER['SERVER_NAME'] == "valleythayne-local")
        {
            header("Location: http://". $_SERVER['HTTP_HOST'] . "/about-rewards.php" );
            die();
        }
        else {
            header("Location: https://" . $_SERVER['SERVER_NAME'] . "/about-rewards.php");
            die();
        }
    }

?>

<script>
//code to highlight selected receipts div
function highlightDiv(divID) {
    var els = document.getElementsByClassName('highlightDiv');
    while (els[0]) {
        els[0].classList.remove("highlightDiv");
    }

    var divIdString = divID['id'];
    var element = document.getElementById(divIdString);
    element.classList.add("highlightDiv");



}
</script>

<style>
#receiptsModal h4 {
    margin: 15px 0 0;
}

@media only screen and (min-width: 768px) {

    html,
    body {
        height: 100% !important;
        width: 90% !important;
        display: contents !important;
        padding-left: 20px !important;
        margin: 20px;
    }

    .wrapper {

        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        -webkit-box-orient: vertical;
        -webkit-box-direction: normal;
        -ms-flex-direction: column;
        flex-direction: column;
        margin-left: 40px;
        height: 100% !important;

    }

    .row {
        display: flex;
        flex-direction: row;
        flex-wrap: wrap;
        width: 100%;
        height: 100%;
        /*  justify-content:center;
        text-align:center; */
    }

    .box {
        /* background-color: #444; */
        /* color: #fff; */
        border-radius: 5px;
        padding: 10px;
        /*font-size: 150%;*/
    }

    .colSummary {
        display: flex;
        flex-direction: column;
        flex: 30%;
        max-width: 30%;
        padding: 0 4px;
        justify-content: self-start;
        flex-wrap: wrap;
        margin-right: 10px;
        margin-left: 10px;
        background-color: beige;
        overflow: scroll;
    }

    .colDetail {
        display: flex;
        flex-direction: column;
        flex: 60%;
        max-width: 60%;
        padding: 0 4px;
        justify-content: space-between;
        flex-wrap: wrap;
        margin-right: 20px;
        background-color: beige;
        overflow: scroll;
        /* max-height: 95% !important; */
    }

    #hero-img {
        margin-left: 3px !important;
        height: 200px;
        max-width: 835px !important;
        width: 835px !important;
        padding-right: 40px !important;
        margin-right: 35px !important;
    }
}

@media only screen and (max-width: 768px) {

    html,
    body {
        height: 100% !important;
        width: 100% !important;
        display: contents !important;
        padding-left: 5px !important;
        /* margin: 5px !important; */
        margin-left: 25px !important;
    }

    .wrapper {

        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        -webkit-box-orient: vertical;
        -webkit-box-direction: normal;
        -ms-flex-direction: column;
        flex-direction: column;
        margin-left: 20px;
        height: 100% !important;
        width: 90% !important;

    }

    .row {
        display: flex;
        flex-direction: row;
        flex-wrap: wrap;
        width: 100%;
        height: 100%;
        /*  justify-content:center;
text-align:center; */
    }

    .colSummary {
        display: flex;
        flex-direction: column;
        flex: 100%;
        max-width: 100%;
        /* max-height: 40%;
        height: 40% !important; */
        height: 300px !important;
        padding: 0 4px;
        justify-content: self-start;
        flex-wrap: wrap;
        /* margin-right: 10px; */
        /* margin-left: 10px; */
        background-color: beige;
        overflow: scroll;
    }

    .colDetail {
        display: flex;
        flex-direction: column;
        flex: 100%;
        max-width: 100%;
        /* max-height: 55% !important; */
        height: 500px !important;
        padding: 0 4px;
        justify-content: space-between;
        flex-wrap: wrap;
        /* margin-right: 20px; */
        background-color: beige;
        overflow: scroll;
        /* max-height: 95% !important; */
    }
}

.highlightDiv {
    background: #ffffff;
}

h6.pointsEarned {
    background: #00669e;
    padding: 12px 20px;
    color: #fff;
    font-size: 18px;
    margin-bottom: 30px;
}

.text-center {
    text-align: center;
}

.receiptLink {
    font-weight: bold !important;
    color: blue !important;
}
</style>

<div class="wrapper">
    <!-- <div class="box row" style="text-align:center; display:block;">
        <div class="column">
            <img src="/Kickstrap/img/ValleyMarket_FuelSiteGraphics_EnjoyTheRewards_Header.png"
                alt="enjoy the Rewards of shopping with us" id="hero-img">
        </div>
    </div> -->
    <div id="blankBuffer"></div>
    <div class="row" id="mainContent">
        <div class="well colSummary" id="allReceiptsContainer">
            <h4><a href="#" id="receiptsLink">Receipts</a> <span class="icon-question-sign pull-right"></span></h4>
            <?php echo str_replace(";", "",str_replace("'", "",$receiptsHTML)) ?>
        </div>


        <div class="well mainSection hideObject colDetail" id="receiptsDisplayContainer">
            <div class="panel text-center">
                <div class="panel-body">
                    <?php
			if(!isset($rewardsReceipts['error'])){
				
				$count = 0;

				foreach($rewardsReceipts as $receipt){
					
					$receiptComponents = explode("\n", $receipt['$POSReceipts$'][0]['TextData']);
					$receiptItems = array_slice($receiptComponents, 4, -16);
			?>
                    <div id="fullReceipt_<?php echo $receipt['TransactionID']; ?>"
                        class="oneReceipt <?php echo $count !== 0 ? 'hideObject' : ''; ?>">
                        <h6 class="pointsEarned">Points Earned: <?php echo floor((float) $receipt['Amount']); ?></h6>
                        <h5><?php echo $receiptComponents[0]; ?></h5>
                        <h4><?php echo $receiptComponents[1]; ?></h4>
                        <p class="mb-30"><?php echo $receiptComponents[3]; ?></p>

                        <?php
						foreach($receiptItems as $item){
							if(trim($item) !== ""){
								$itemComponents = explode("$", $item);
								?>
                        <p class="clearfix text-left">
                            <span class="pull-left">
                                <span><?php echo strtoupper($itemComponents[0]); ?></span>
                                <?php
										if(isset($itemComponents['qty']) && !is_null($itemComponents['qty'])){
											?>
                                <br>
                                <span style="margin-left:20px;display: block;">
                                    QTY
                                    <?php
												echo $itemComponents['qty'];
												?>
                                </span>
                                <?php
										}
			?>
                            </span>
                            <span class="pull-right">$<?php 
                                    if(!isset($itemComponents[1]))
                                    {echo "$0.00";}
                                        else{
                                    echo $itemComponents[1]; 
                                }
                                ?></span>
                        </p>
                        <?php
							}
						}
			?>
                        <div class="receiptTotalInfo mt-20">
                            <p class="clearfix">
                                <?php
								$subTotal = explode("$", $receiptComponents[count($receiptComponents)-16]);
			?>
                                <span class="pull-left">SUB TOTAL</span>
                                <span class="pull-right">$<?php echo $subTotal[1]; ?></span>
                            </p>

                            <p class="clearfix">
                                <?php
								$totalTax = explode("$", $receiptComponents[count($receiptComponents)-15]);
			?>
                                <span class="pull-left">TOTAL TAX</span>
                                <span class="pull-right">$<?php echo $totalTax[1]; ?></span>
                            </p>

                            <p class="clearfix">
                                <?php
								$total = explode("$", $receiptComponents[count($receiptComponents)-14]);
			?>
                                <span class="pull-left">TOTAL</span>
                                <span class="pull-right">$<?php echo $total[1]; ?></span>
                            </p>
                        </div>

                        <div class="receiptTenderedInfo mt-20">
                            <p class="clearfix">
                                <?php
								$balanceDue = explode("$", $receiptComponents[count($receiptComponents)-12]);
			?>
                                <span class="pull-left">BALANCE DUE</span>
                                <span class="pull-right">$<?php echo $balanceDue[1]; ?></span>
                            </p>

                            <p class="clearfix">
                                <?php
								$tendered = explode("$", $receiptComponents[count($receiptComponents)-11]);
			?>
                                <span class="pull-left">TENDERED</span>
                                <span class="pull-right">$<?php echo $tendered[1]; ?></span>
                            </p>
                        </div>

                        <div class="receiptDateInfo mt-50">
                            <p class="mb-20"><?php echo $receiptComponents[count($receiptComponents)-8]; ?></p>
                            <p><?php echo $receiptComponents[count($receiptComponents)-6]; ?></p>
                            <p><?php echo $receiptComponents[count($receiptComponents)-5]; ?></p>
                            <p><?php echo $receiptComponents[count($receiptComponents)-4]; ?></p>
                            <p><?php echo $receiptComponents[count($receiptComponents)-3]; ?></p>
                        </div>
                    </div>
                    <?php
					$count++;
				}
			}else{
			?>
                    <h3>Sample receipt details to display</h3>
                    <div <?php echo str_replace('"', "",$receiptDetailsID) ?>>
                        <h6>Points Earned: </h6>
                        <h5>Accelitec Interact Generated Script</h5>
                        <p class="mb-30">Loyalty #43040166457</p>
                    </div>
                    <?php
			}
			?>
                </div>
            </div>
        </div>

    </div>
</div>


<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>
<script>
/* $(document).ready(function() {
    $('#closeReceiptsBtn').click(function() {
        window.setTimeout(function() {
            $('#receiptsDetails').modal('hide');
        }, 500);
    });
}); */

$(document).ready(function() {
    $("div").click(function() {
        $("div").removeClass('current');
        $(this).addClass('current');
    });

    if (!$(this).closest(".receiptLinkContainer").length) {
        console.log("receiptsLinkContainer not found");
    } else {
        var id = $(this).closest('.receiptLinkContainer').attr('id').replace('receiptLink_', '');
        $("#fullReceipt_" + id).removeClass("hideObject");
    }
});

//Receipts Code
$("#receiptsLink").on("touch click", function(e) {
    e.preventDefault();

    $("#rewardsContentContainer .mainSection").addClass('hideObject');
    $("#receiptsDisplayContainer").removeClass('hideObject');
    $("#sideNavigation .well").removeClass('active');
    $("#allReceiptsContainer").addClass("active");
});


$(".receiptLink").on("touch click", function(e) {
    e.preventDefault();

    if (!$(this).closest(".receiptLinkContainer").length) {
        console.log("receiptsLinkContainer not found");
    } else {
        var id = $(this).closest('.receiptLinkContainer').attr('id').replace('receiptLink_', '');

        $("#rewardsContentContainer .mainSection").addClass('hideObject');
        $("#receiptsDisplayContainer").removeClass('hideObject');
        $("#receiptsDisplayContainer .oneReceipt").addClass("hideObject");
        $("#fullReceipt_" + id).removeClass("hideObject");
        $("#sideNavigation .well").removeClass('active');
        $("#allReceiptsContainer").addClass("active");
    }
});
</script>