<?php
	include_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/sessionStartGeneral.php");
	include($_SERVER['DOCUMENT_ROOT'] . '/admin/inc/lunchSpecialsConfig.php');
?>
<?php
  $pageTitle = $lunchConfig['branded'];
  $pageDescription = "At " . STORE_NAME . ", we are excited to offer you a lunch deal from our deli that is both delicious and affordable.";
  $pageKeywords = "deli, lunch, lunch special, lunch deal";
?>
<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php");
?>
	<script src="https://afsshareportal.com/js/moment.min.js"></script>
<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/mainNav.php");
?>



    
    <section class="container">
      <div id="blankBuffer"></div>
      <div id="noEditError" class="hideObject">
			<div class="alert alert-error">
				  <a class="close" data-dismiss="alert" href="#">x</a>You can only <span id="noEditErrorText"></span> if you have editing capabilities.
			</div>
	  </div>
	  <section class="container" id="mainContent">
	    <article class="row" id="siteContentContainer">
		  
		  <div class="span12 leftSide">
			<div class="contentContain">
			  <h2><?php echo $lunchConfig['branded']; ?></h2>
			  <div id="lunchContain">
				<div class="clearfix">
				  <div id="calendar" class="hidden-phone">
					<?php include('admin/inc/calendar.php'); ?>
				  </div>
				  <div id="viewLunch">
					<div id="changeLunchContain">
					  
					</div>
				  </div>
				</div>
				
				<div id="weeklyLunch">
				  
				</div>
			  </div>
			  
			</div>
		  </div>
		  
	    </article>
	    
      </section>
      
    </section>
      

  
  <script src="admin/js/includeJS.js"></script>
  <script>
	var deliItems = new Array();
	var deliDropdown = "";
	
	var config = <?php echo json_encode($lunchConfig); ?>;
	delete config['branded'];
	var objCount = $.map(config, function(n, i) { return i; }).length;
	
	$(".day").live("click", function(){
	  $(".pickedDay").removeClass("pickedDay");
	  $(this).addClass("pickedDay");
	  var theDate = $(this).attr("rel");
	  
	  $.ajax({
	    type: "POST",
	    url: "admin/lookUp.php",
	    data: "action=getLunchDay&date=" + theDate,
	    dataType: "json",
	    success: function(theResponse){
		  var theHTML = "";
		  var localConfig = jQuery.extend(true, {}, config);
		  
		  if(theResponse != false){
			
			$.each(theResponse, function(){
				localConfig[this['deli_type']]["has-special"] = true;
				localConfig[this['deli_type']]['item'] = this;
			});
			
			theHTML += "<h3>" + formatDateNice(theDate) + "</h3>";
			
			var currentType = "";
			$.each(localConfig, function(key){
				
				if(this['common-name'] != currentType){
					if(currentType != ""){
						theHTML += "</div>";
					}
					theHTML += "<div id='container_" + this['common-name'] + "'>";
				}
				
				if(this['has-special'] !== false){
					var deliID = this['item']['deli_id'];
					theHTML += "<div class='aSpecial'>";
					theHTML += "<h4>" + this['common-uc'] + " Special</h4>";
					theHTML += "<img class='floatLeftImg' src='/" + deliItems[deliID]['photo'] + "' width='100%' alt='" + this['common-uc'] + "'>";
					theHTML += "<h3>" + deliItems[deliID]['name'] + "</h3>";
					if(theResponse[0]['item_price'] != "$."){
						theHTML += "<h4>" + this['item']['item_price'] + "</h4>";
					}
					theHTML += "<p class='clearfix'>" + this['item']['item_desc'] + "</p>";
					theHTML += "</div>";
				}else{
					if(this['common-name'] == "lunch"){
						theHTML += getCommonSpecial("aSpecial", "100%", "lunch");
					}
				}
				
				currentType = this['common-name'];
			});
		  }else{
			theHTML += "<h3>" + formatDateNice(theDate) + "</h3>";
			theHTML += getCommonSpecial("aSpecial", "100%", localConfig[1]['common-name']);
		  }
		  
			
		  $("#viewLunch").html(theHTML);
		  
		  $("#viewLunch").attr("rel", theDate);
		  
		  delete localConfig;
	    }
      });
	  weeklyLunch("#weeklyLunch", theDate);
	});
	
	
	getLunchOptions();
	
	
	$("#nextMonth, #prevMonth").live("click", function(){
	  $("#viewLunch").html("Select a date to see the special");
	  $("#weeklyLunch").html("");
	  var type = $(this).attr("id");
	  var theDate = $(".calendar").attr("id");
	  
	 
	  if(type == "nextMonth"){
		var dateComponents = moment(theDate).add('M', 1);
	  }else{
		var dateComponents = moment(theDate).subtract('M', 1);
	  }
	  
	  
	  var monthNum = ("0" + (dateComponents.month() + 1)).slice(-2);
	  var month = dateComponents.format("MMMM");
	  var year = dateComponents.year();
	  var dayDate = ("0" + dateComponents.date()).slice(-2);
	  var refDate = year + "-" + monthNum + "-" + dayDate;
	  var newCalendar = buildCalendar(month, year, refDate);
	  
	  $("#calendar").html(newCalendar);
	  
	  if(objCount == 1){
		getMonthLunch($(".calendar").attr("id"));
	  }
	});
   
    function weeklyLunch(htmlLocation, theDate){
	  //Get the previous Sunday
	  var sunDate = moment(theDate);
	  if(sunDate.day() < 6){
		//set the day of month to day of month + 1 - day of week + 1
		sunDate.date((sunDate.date() + 1) - (sunDate.day() + 1));
	  }else if(sunDate.getDay() == 6){
		sunDate.date((sunDate.date() + 1));
	  }
	  
	  var startDate = sunDate.format("YYYY-MM-DD");
	  sunDate.date(sunDate.date() + 6)
	  var endDate = sunDate.format("YYYY-MM-DD");
	  
	  //console.log("startDate: " + startDate + "\nendDate: " + endDate);
	  $.ajax({
	    type: "POST",
	    url: "admin/lookUp.php",
	    data: "action=getLunchWeek&startDate=" + startDate + "&endDate=" + endDate,
	    dataType: "json",
	    success: function(theResponse){
		  if(theResponse != false){
			niceStartDate = formatDateNice(startDate, true);
			var theHTML = "<h2>Specials for the week of " + niceStartDate + "</h2>";
			var weeklyConfig = jQuery.extend(true, {}, config);
			
			$.each(theResponse, function(){
				var type = weeklyConfig[this['deli_type']];
				
				deliID = this.deli_id;
				var niceDate = formatDateNice(this.deli_date, false);
				theHTML += "<div class='aLunch'>";
				theHTML += "<p>" + niceDate + "</p>";
				theHTML += "<h5 class='typeHeading'>" + type['common-uc'] + " Special</h5>";
				theHTML += "<img src='/" + deliItems[deliID]['photo'] + "' width='100%' alt='" + type['common-uc'] + "'>";
				theHTML += "<h4>" + deliItems[deliID]['name'] + "</h4>";
				if(this.item_price != "$."){
					theHTML += "<h5 class='clearfix'>" + this.item_price + "</h5>";
				}
				theHTML += "</div>";
			});
		  }else{
			theHTML = "";
		  }
		  
		  $(htmlLocation).html(theHTML);
		  
		  setTimeout(function(){
			var highest = null;
			var hi = 0;
			
			$(".aLunch").each(function(){
			  var h = $(this).height();
			  if(h > hi){
				 hi = h;
				 highest = $(this).height();  
			  }    
			}).height(highest).css("margin-bottom", "20px");
		  },1000);
	    }
      });
	}
	
	function getMonthLunch(theDate){
	  //theDate = theDate.replace(/-/g, "");
	  //var useDate = theDate.replace(/(\d{4})(\d{2})(\d{2})/, '$1, $2, $3');
	  var firstDay = new moment(theDate);
	  var startDate = firstDay.format("YYYY-MM-DD");
	  var numberDays = firstDay.daysInMonth();
	  firstDay.date(firstDay.date() + (numberDays-1))
	  var endDate = firstDay.format("YYYY-MM-DD");
	  
	  $.ajax({
	    type: "POST",
	    url: "admin/lookUp.php",
	    data: "action=getLunchWeek&startDate=" + startDate + "&endDate=" + endDate,
	    dataType: "json",
	    success: function(theResponse){
		  $.each(theResponse, function(){
			var theHTML = "";
			deliID = this.deli_id;
			var itemName = deliItems[deliID]['name'];
			theHTML += "<p>" + itemName + "</p>";
			$(".day[rel='" + this.deli_date + "']").append(theHTML);
		  });
		  
	    }
      });
	}
	
	
   ks.ready(function() {
      // JavaScript placed here will run only once Kickstrap has loaded successfully.
      $("#today_date").click();
	  if(objCount == 1){
		getMonthLunch($(".calendar").attr("id"));
	  }
      
   });
  </script>
  
<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>
