<?php
  if(!isset($_SESSION)){
	session_start();
  }

  include_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/sessionStartGeneral.php");
  
  if(isset($loggedIn) && $loggedIn === true){
$pageTitle = "Rewards";
$pageDescription = "Grocery and Fuel Rewards";
$pageKeywords = "Thayne, Wyoming, grocery, store, market, fresh foods, Wyoming, grocery, Valley Market Thayne, grocery store";

$theSiteParts = explode(".", $_SERVER['HTTP_HOST']);
$theSite = $theSiteParts[0];

	require_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/class.brdata.inc.php");
	$brdataObj = new brdata();
	$theUser = $brdataObj->getUser($_SESSION['FrequentShopperNum']);
	
	require_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/class.rewards.inc.php");
	$rewardsUserObj = new rewards($theUser['Phone']);
	//$rewardsUserObj->preferredStore = $theUser['MyStore']['MyStoreNumber'];
	
	$rewardsReceipts = $rewardsUserObj->getUserOrderSummary();
	
	list($userCredit, $userPoints, $accountError) = $rewardsUserObj->getUserCreditPoints($theUser['Phone']);
	
    list($personalOffers, $commonOffers) = $rewardsUserObj->getAccountPromotions();
    $fuelRewardBalance = $rewardsUserObj->getFuelRewardBalance();
    if (isset($fuelRewardBalance['error']) )
    {
        $availableCentsPerGallonReward = 0;
    } 
    else {
    $availableCentsPerGallonReward = $fuelRewardBalance['AvailableCentsPerGallonReward'];
    }

	$availableCharities = $brdataObj->getCharities($_SESSION['FrequentShopperNum']);
    $userCharities = $brdataObj->getUserCharities($_SESSION['FrequentShopperNum']);
    
    //  CREDIT BALANCE CALCULATIONS
    // ******************************************************
    //$userPoints['Balance'] = "423.0000";
    $userPoints['Balance'] = (float) $userPoints['Balance'];

    $minPoints = 30;

    $earnedTotal = floor($userPoints['Balance'] / 100) * 10;
    $potentialTotal = (($userPoints['Balance'] / 1000) * 100);
    $earnedTotalCeil = ceil($userPoints['Balance'] / 100) * 10;

    if($earnedTotal < $minPoints){
    $earnedTotal = 0;
    $earnedTotalCeil = $minPoints;
    }else if($earnedTotal >100){
    $earnedTotal = 100;
    $earnedTotalCeil = 100;
    $potentialTotal = 100;
    }

  }else{
    if ($_SERVER['SERVER_NAME'] == "valleythayne-local")
    {        
        header("Location:http://". $_SERVER['HTTP_HOST'] . "/about-rewards.php" );
        die();
    }
    else {       
        header("Location:https://" . $_SERVER['SERVER_NAME'] . "/about-rewards.php");
        die();
    }
    
  }
  $theError = false;
  
?>



<?php

require($_SERVER['DOCUMENT_ROOT'] . '/common/mainNav.php');
include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php");

if (isset($_GET["program"])) {
$type = htmlspecialchars($_GET["program"]) ;
} else 
{
    $type = "grocery";
}

if (isset($_GET["complete"])) {
$percentageComplete = htmlspecialchars($_GET["complete"]) ;
$percCompleteText= $percentageComplete.'%';
} 
else {
    $percentageComplete = $userPoints['Balance'];
    if( $percentageComplete == "0")
    {
        $percentageComplete = 10;
    }
    else {
        $percentageComplete = (100-$userPoints['Balance']);

        if ($percentageComplete < 1)
        {
            $percentageComplete = 0.5;
        }
    }
    $percCompleteText =  $percentageComplete.'%';
}
// $rewardProgramType = "grocery" /* grocery fuel   */
if (count($_SESSION['RewardSubscriptions']) > 0 ) {
    if ($_SESSION['RewardSubscriptions']['RewardSubscriptionName']  == "Fuel Rewards")
    {
        $rewardProgramType = "fuel";
    }
    else {
        $rewardProgramType = "grocery";
    }
}else {
$rewardProgramType = $type;
}

$imgSrc = "";
$imgAlt = "";
$imgId = "";

if ($rewardProgramType  == "grocery")
{
    $imgSrc = "/Kickstrap/img/ValleyMarket_FuelSiteGraphics_GroceryBag_Graphic.png";
    $imgAlt = "Grocery bag graphic";
    $imgId = "imgGrocery";
}
else {

    $imgSrc = "/Kickstrap/img/ValleyMarket_FuelSiteGraphics_FuelPump_Graphic.png";
    $imgAlt = "Fuel pump graphic";
    $imgId = "imgFuel";
}

?>

<style>
.howItWorks {

    display: -webkit-flex;
    display: flex;
    -webkit-flex-direction: column;
    flex-direction: column;
    -webkit-align-items: flex-start;
    align-items: flex-start;
}

.getStarted {

    display: -webkit-flex;
    display: flex;
    -webkit-flex-direction: column;
    flex-direction: column;
    -webkit-align-items: flex-start;
    align-items: flex-start;
}



.hero {

    display: flex;
    justify-content: center;
    align-items: center;
}

.howToRedeemPoints {

    display: -webkit-flex;
    display: flex;
    -webkit-flex-direction: column;
    flex-direction: column;
    -webkit-align-items: flex-start;
    align-items: flex-start;
}


.sectionHeader {
    display: flex;
    flex-direction: row;
    align-items: flex-start;
    margin-top: 0px;
    padding: 0px;
    color: #FFFF00;
}

.sectionColumns {
    display: flex;
    flex-direction: row;
    align-items: flex-start;
    margin-top: 0px;
    padding: 0px;
}

.row {
    display: flex;
}

.sectionGraphics {
    flex: 108%;
    padding: 10px;
}

.sectionContent {
    flex: 100%;
    padding: 10px;
}

.wrapper {
    background-color: #fff;
    color: #444;
}


@media only screen and (max-width: 768px) {

    html,
    body {
        height: 100% !important;
        width: 100% !important;
        display: contents !important;
        padding: 0px !important;
        margin: 0px !important;
        margin-left: 35px !important;
        margin-right: 5px !important;
    }

    .wrapper {
        max-width: 100% !important;
        margin: 10px auto 0 auto !important;
        display: block !important;
        padding: 10px !important;
    }

    .alignButtons {
        text-align: center;
    }



    ::root {
        --bgDiv-color: #f79e1e;
        /* the default */
        --bgDiv-width: 100px;
        --bgDiv-height: 200px;
        --offersRowDirection: column;
    }

    .parentOffers {
        display: flex;
        align-items: center;
        width: 100%;
    }

    #offersRow1 {
        justify-content: space-between;
    }

    #offersRow2 {
        justify-content: flex-start;
    }

    #offersRow3 {
        justify-content: space-between;
    }

    #offersRow4 {
        justify-content: flex-end;
    }

    .path-color {
        background-color: #f79e1e;
        fill: #f79e1e;
        /* width:50%; */
        /* width: 350px;
        margin-bottom: 200px; */
    }


    image.svgImg {
        /* width:350px;s */
    }

    .svgImg {
        /*  width: 350px;
        height:350px; */
        /* width:auto; */
    }

    .alignButtons {
        display: flex;
        flex-wrap: wrap;
        text-align: center;
        margin-top: 10px;
        margin-left: 10px;
        margin-bottom: 20px;
        padding-bottom: 20px;
        margin-right: 20px;
        justify-content: center;
    }

    .btn-primary {
        margin-bottom: 10px !important;
    }

    .summary {
        display: flex;
        flex-wrap: wrap !important;
        justify-self: center;
        text-align: center;
        width: 330px !important;

    }

    .rewardPoints-1 img {
        width: 80%;
    }

    .rewardPoints-1 {

        display: -webkit-flex;
        display: flex;
        width: 30% !important;

    }

    .rewardPoints-2 {

        display: -webkit-flex !important;
        display: flex !important;
        width: 40% !important;
        /* padding-right: 10px !important; */
    }

    .grayBox {
        background-color: #dcdcdc;
        /* color: #fff; */
        border-radius: 5px;
        padding: 10px;
        width: 150px;
        padding-right: 10px !important;
        margin-right: 25px !important;
        /*font-size: 150%;*/
    }

    #txtWalletCredit {
        max-height: 60px !important;
        height: 60px !important;
        max-width: 100% !important;
        font-size: 23px !important;
    }

    .myGradient {
        display: flex;
        align background-position: center;
        height: var(--bgDiv-height);
        width: 175px;
        margin-right: 5px;
        opacity: 0.7;
        z-index: 50;
        border-radius: 30px;

        background-color: var(--bgDiv-color);

        /* For browsers that do not support gradients */

        /* background-image: linear-gradient(to bottom, rgba(255, 255, 255), 30%, #f79e1e 70%); */

        /* Standard syntax (must be last) */
    }

    .rewardOffers-summary {

        display: flex;
        justify-self: center;
        margin-left: 15px;
        margin-right: 15px;
        text-align: center;
    }

    .instantSavings-summary {
        display: flex;
        justify-self: center;
        margin-left: 15px;
        margin-right: 15px;
        text-align: center;
    }

    .rewardOffers-1-a {
        display: flex;
        justify-self: self-start;
        margin: 5px;
        text-align: start;
    }

    .rewardOffers-1-b {
        display: flex;
        justify-self: self-end;
        margin: 5px;
        text-align: start;
    }

    .rewardOffers-2-a {
        display: flex !important;
        margin: 5px !important;
        /* justify-items: left: */
        text-align: left !important;
    }

    .rewardOffers-2-b {
        display: flex !important;
        margin: 5px !important;
        justify-items: left !important;
        text-align: left !important;
        width: 272.92px !important;
    }

    .rewardOffers-3-a {
        display: flex !important;
        margin: 5px !important;
        /* justify-items: left: */
        text-align: left !important;
    }

    .rewardOffers-3-b {
        display: flex !important;
        margin: 5px !important;
        justify-items: left !important;
        text-align: left !important;
        width: 272.92px !important;
    }

    h1#instantSavingsHeader {
        text-align: center !important;
        margin-left: 50px !important;
    }

    .accordion-inner {
        border: none !important;
    }

    .accordion-group {
        border: none !important;
    }

    /*   .onecoupon {
        max-height: auto !important;
        max-width: 30% !important;
        float: left !important;
    }

    img.onecoupon {
        max-height: 90.03px !important;
        max-width: 90.03px !important;
    } */

    .couponcontent {
        width: 65%;
        float: right;
    }

    .imageContain {
        float: left !important;
        margin-left: 4px !important;
        width: 30% !important;
        margin-right: 5px !important;
    }

    .onecoupon {
        /*  max-height: 147px !important;
        max-width: 323px !important; */
        float: left !important;
        width: 95% !important;
        padding: 10px !important;
        border-top-color: rgb(238, 238, 238) !important;
        border-top-style: solid !important;
        border-top-width: 1px !important;
        border-right-color: rgb(238, 238, 238) !important;
        border-right-style: solid !important;
        border-right-width: 1px !important;
        border-bottom-color: rgb(238, 238, 238) !important;
        border-bottom-style: solid !important;
        border-bottom-width: 1px !important;
        border-left-color: rgb(238, 238, 238) !important;
        border-left-style: solid !important;
        border-left-width: 1px !important;
        border-image-source: initial !important;
        border-image-slice: initial !important;
        border-image-width: initial !important;
        border-image-outset: initial !important;
        border-image-repeat: initial !important;
        /* position: relative !important; */
        margin-top: 0px !important;
        margin-right: 1% !important;
        margin-bottom: 20px !important;
        margin-left: 1% !important;
        background-image: initial !important;
        background-position-x: initial !important;
        background-position-y: initial !important;
        background-size: initial !important;
        background-repeat-x: initial !important;
        background-repeat-y: initial !important;
        background-attachment: initial !important;
        background-origin: initial !important;
        background-clip: initial !important;
        background-color: rgb(255, 255, 255) !important;
        /* min-height: 130px !important; */
    }

    .icon-question-sign {
        /* position: absolute !important; */
        top: 10px !important;
        right: 10px !important;
        font-size: 14px !important;
        color: #999 !important;
        opacity: 1 !important;
    }

    div#rowRewardPoints.row {
        width: 370px !important;
    }

    hr {
        position: relative;
        /* top: 20px; */
        border: none;
        height: 5px;
        background: black;
        margin-bottom: 20px;
    }

}


@media only screen and (min-width: 768px) {
    ::root {
        --bgDiv-color: #f79e1e;
        --bgDiv-width: 100px;
        --bgDiv-height: 600px;
    }

    html,
    body {
        height: 100% !important;
        width: 90% !important;
        display: contents !important;
        padding-left: 20px !important;
        margin: 20px;
    }

    #instantSavingsHeader {
        margin-left: 15px !important;
    }


    .wrapper {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        -webkit-box-orient: vertical;
        -webkit-box-direction: normal;
        -ms-flex-direction: column;
        flex-direction: column;
        /* margin-left: 20px !important; */
        margin-right: 20px !important;
    }

    svg {
        margin-bottom: 20px !important;
    }


    .rewardoffer-summary {
        margin-bottom: 20px !important;
    }

    .instantsavings {
        margin-bottom: 20px !important;
        margin-top: 20px !important;
    }

    .rewardPoints-1 img {
        width: 80%;
        height: 100%;
        object-fit: cover;
        z-index: 100;
    }

    .myGradient {
        display: flex;
        align background-position: center;
        height: var(--bgDiv-height);
        width: var(--bgDiv-width);
        margin-left: 1px;
        /*  grid-column: 2/3;
        grid-row: 3/4; */
        opacity: 0.7;
        /*  border: 2px solid #f79e1e;
        border-radius: 10px; */
        /* margin-top: calc(100% - 200px); */
        z-index: 50;
        border-radius: 30px;

        background-color: var(--bgDiv-color);



        /* For browsers that do not support gradients */

        /* background-image: linear-gradient(to bottom, rgba(255, 255, 255), 30%, #f79e1e 70%); */

        /* Standard syntax (must be last) */
    }

    .path-color {
        background-color: #f79e1e;
        fill: #f79e1e;
    }

    .gradient {
        display: flex;
        height: 621.33px;
        width: 535.25px;
        margin-left: 15px;
        /*  grid-column: 2/3;
        grid-row: 3/4; */
        opacity: 0.7;
        border: 2px solid #f79e1e;
        border-radius: 10px;
        background-color: transparent;
        background-image:
            linear-gradient(to bottom,

                transparent 25%,

                #f79e1e 15%);
    }

    #fuelScoreCard {
        max-width: 250px !important;
    }

    #groceryScoreCard {
        max-width: 250px !important;
    }

    #summaryContent {
        max-width: 850px;
    }

    .parentOffers {
        display: flex;
        align-items: center;
        width: 100%;
    }

    #offersRow1 {
        justify-content: space-between;
        /* padding:0px; */
        /* padding-right: 15px; */
        width: 85% !important;
        background-color: none !important;
        padding-left: 50px !important;
        margin-left: 20px !important;
    }

    #offersRow2 {
        justify-content: flex-start;
        width: 85% !important;
        background-color: none !important;
        padding-left: 50px !important;
        margin-left: 20px !important;
    }

    #offersRow3 {
        justify-content: space-between;
        /* padding:0px; */
        /* padding-right: 15px; */
        width: 85% !important;
        background-color: none !important;
        padding-left: 50px !important;
        oadding-top: 10px !important;
        margin-left: 20px !important;
    }

    #offersRow4 {
        display: flex;
        justify-content: flex-end;
        max-height: 90px !important;
        text-align: right !important;
        width: 85% !important;
        background-color: none !important;
        padding-left: 50px !important;
        padding-top: 10px !important;
        /* margin-left: 20px !important; */
    }
   
    .accordion {
        margin-bottom: 0px !important;
    }

    .accordion-heading,
    .accordion-toggle {
        padding: 0px !important;
    }

    .accordion-group {
        border: none;
    }

    .accordion-inner {
        padding: 0px;
        /* padding-left: 15px; */
        border: none;
        width: 100% !important;
        max-height: 100% !important;
        vertical-align: middle !important;
        /* max-height: 100px !important; */
        /* text-align: center !important; */
    }


    div.box.summary {
        align-content: center !important;
        width: 90% !important;
        background-color: none !important;
        padding-left: 50px !important;
        margin-left: 20px !important;
    }

    .sectionHeader {
        padding-left: 30px !important;
        margin-left: 40px !important;
    }

    div.row {
        align-content: center !important;
        width: 90% !important;
        background-color: none !important;
        padding-left: 50px !important;
        /* margin-left: 20px !important; */

    }

    #headerLearnMore {
        text-align: right;
        color: #f79e1e;
    }

    .oneCouponModal {
        width: 497px !important;
        height: 186.94 !important;
    }

    .onecoupon {
        /*  max-height: 147px !important;
        max-width: 323px !important; */
        float: left !important;
        width: 27% !important;
        padding: 10px !important;
        border-top-color: rgb(238, 238, 238) !important;
        border-top-style: solid !important;
        border-top-width: 1px !important;
        border-right-color: rgb(238, 238, 238) !important;
        border-right-style: solid !important;
        border-right-width: 1px !important;
        border-bottom-color: rgb(238, 238, 238) !important;
        border-bottom-style: solid !important;
        border-bottom-width: 1px !important;
        border-left-color: rgb(238, 238, 238) !important;
        border-left-style: solid !important;
        border-left-width: 1px !important;
        border-image-source: initial !important;
        border-image-slice: initial !important;
        border-image-width: initial !important;
        border-image-outset: initial !important;
        border-image-repeat: initial !important;
        position: relative !important;
        margin-top: 0px !important;
        margin-right: 1% !important;
        margin-bottom: 20px !important;
        margin-left: 1% !important;
        background-image: initial !important;
        background-position-x: initial !important;
        background-position-y: initial !important;
        background-size: initial !important;
        background-repeat-x: initial !important;
        background-repeat-y: initial !important;
        background-attachment: initial !important;
        background-origin: initial !important;
        background-clip: initial !important;
        background-color: rgb(255, 255, 255) !important;
        min-height: 130px !important;
    }

    img.onecoupon {
        max-height: 166.94px !important;
        max-width: 166.94px !important;
    }

    .coupon-modal-body {
        width: 560px !important;
        height: 216.94px !important;
        max-height: 216.94px !important;
        color: #555555 !important;
        padding: 15px !important;
    }

    .couponDescription {
        color: #555555 !important;
        margin: 0px 0px 9.5px !important;
        font-size: 10px !important;
        text-align: right !important;
    }

    .imageContain {
        float: left !important;
        margin-left: 4px !important;
        width: 30% !important;
    }

    .imageContainModal {
        width: 166.94 !important;
        height: 166.94 !important;
    }

    .restrictionsModal {
        width: 286.19px !important;
        height: 19px !important;
        font-size: 11.05px !important;
        font-family: "Helvetica Neue", Helvetica, sans-serif !important;
        margin: 0px 0px 9.5px !important;
    }

    .couponContentModal {
        width: 286.49px !important;
        height: 151.5px !important;

    }

    .couponInformationModal {
        width: 286.49px !important;
        height: 150px !important;
        float: right !important;
        position: absolute !important;
        top: 15px !important;
        left: 200px !important;
    }

    .parentCoupons {
        display: flex;
        /* align-items: center; */
        width: 100%;
    }

    #couponsRow1 {
        display: flex !important;
        justify-content: space-between;
        /* padding:0px; */
        /* padding-right: 15px; */
        width: 95% !important;
        background-color: none !important;
        padding-left: 35px !important;
        margin-left: 35px !important;
        flex-direction: row !important;
    }

    .icon-question-sign {
        position: absolute !important;
        top: 10px !important;
        right: 10px !important;
        font-size: 14px !important;
        color: #999 !important;
        opacity: 1 !important;
    }

    #noOffers {
        margin-left: 65px !important;
    }

    #noCoupons {
        /* margin-left: 50px !important; */
        /* margin-right: 5px !important; */
        /* text-align: left !important; */
    }

    #summaryInstantSavings {
        display: flex !important;
        flex-wrap: wrap !important;
        padding-left: 10px !important;
        padding-right: 10px !important;
    }

    #levelUpContentRow {
        margin-left: 15px !important;
    }

    /*    .bar-success {
        background-color: green;
    }

    .bar-primary {
        background-color: orange;
    } */

    .bar-success {
        font: bold 20px arial, sans-serif;
        background-color: #71BF0C;
        color: #71BF0C;
        /*   color: transparent; */
        /*   text-shadow: 2px 2px 3px rgba(255,255,255,0.5); */
        /*   -webkit-background-clip: text; */
        -moz-background-clip: text;
        background-clip: text;
        height: 15px !important;
        padding-bottom: 5px !important;
    }

    .bar-primary {
        font: bold 20px arial, sans-serif;
        background-color: #f79e1e;
        color: #f79e1e;
        /*   color: transparent; */
        /*   text-shadow: 2px 2px 3px rgba(255,255,255,0.5); */
        /*   -webkit-background-clip: text; */
        -moz-background-clip: text;
        background-clip: text;
        height: 15px !important;
        padding-bottom: 5px !important;
    }

    hr {
        position: relative;
        /* top: 20px; */
        border: none;
        height: 5px;
        background: black;
        margin-bottom: 20px;
        justify-content: center !important;
        padding-right: 40px !important;
    }

}

.box {
    /* background-color: #dcdcdc; */
    /* color: #fff; */
    border-radius: 5px;
    padding: 10px;
    /*font-size: 150%;*/
}

.grayBox {
    background-color: #dcdcdc;
    /* color: #fff; */
    border-radius: 5px;
    padding: 10px;
    /*font-size: 150%;*/
}

.hero,
.howToRedeemPoints {
    background-color: #999;
}

.getStarted {
    background-color: #ccc;
    color: #444;
}

li {
    list-style: none;
}

.alignButtons {
    align-self: center;
    /*padding-right: 100px;*/
}

.alignContent {
    text-align: center;
}

.summary {

    display: -webkit-flex;
    display: flex;
    -webkit-flex-direction: column;
    flex-direction: column;
    -webkit-align-items: flex-start;
    align-items: flex-start;
    /* margin-bottom: 10px; */
    /* flex-wrap: wrap; */
    /* max-width: 900px; */
}

.rewardPoints-summary {

    display: -webkit-flex;
    display: flex;
    -webkit-flex-direction: column;
    flex-direction: column;
    -webkit-align-items: flex-start;
    align-items: flex-start;
}

.rewardPoints-1 {

    display: -webkit-flex;
    display: flex;
    flex-direction: row;
    align-items: flex-start;
    margin-top: 0px;
    padding: 0px;
}

.rewardPoints-2 {

    display: -webkit-flex !important;
    display: flex !important;
    flex-direction: row !important;
    align-items: flex-end !important;
    -webkit-align-items: center !important;
    justify-content: center !important;
    height: 100% !important;
    margin: auto !important;
    margin-right: 20px !important;
    /* padding-right: 20px !important; */
    padding: 0px !important;
    justify-self: center !important;
}

.rewardOffers-summary {

    display: -webkit-flex;
    display: flex;
    -webkit-flex-direction: column;
    flex-direction: column;
    -webkit-align-items: flex-start;
    align-items: flex-start;
    flex-wrap: wrap;
}

.rewardOffers-1-a {

    display: -webkit-flex;
    display: flex;
    flex-direction: column;
    align-items: flex-start;
    margin-top: 0px;
    padding: 0px;
    margin-left: 10px;
}


.rewardOffers-1-b {

    display: -webkit-flex;
    display: flex;
    flex-direction: column;
    align-items: flex-start;
    margin-top: 0px;
    padding: 0px;
    margin-left: 10px;
}

.rewardOffers-2-a {

    display: -webkit-flex;
    display: flex;
    flex-direction: row;
    align-items: flex-start;
    margin-top: 0px;
    padding: 0px;
    margin-left: 10px;
}


.rewardOffers-2-b {

    display: -webkit-flex;
    display: flex;
    flex-direction: row;
    align-items: flex-end;
    margin-top: 0px;
    padding: 0px;
    margin-left: 10px;
}

.rewardOffers-3-a {

    display: -webkit-flex;
    display: flex;
    flex-direction: row;
    align-items: flex-start;
    margin-top: 0px;
    padding: 0px;
    margin-left: 10px;
}


.rewardOffers-3-b {

    display: -webkit-flex;
    display: flex;
    flex-direction: row;
    align-items: flex-end;
    margin-top: 0px;
    padding: 0px;
    margin-left: 10px;
}

.bigHr {
    background-color: dimgrey !important;
    color: dimgrey !important;
    border: solid 2px dimgrey !important;
    height: 10px !important;
    width: 1000px !important;
}

.instantSavings {

    display: -webkit-flex;
    display: flex;
    -webkit-flex-direction: column;
    flex-direction: column;
    -webkit-align-items: flex-start;
    align-items: flex-start;
}

#txtWalletCredit {
    max-height: 60px !important;
    height: 60px !important;
}


/* clipRect {
    transition: y 7s;

} */
</style>

<div class="wrapper">

    <div class="box summary">
        <div>
            <h1 style="color:#f79e1e;">You're on your way to savings</h1>
        </div>


        <div id="summaryContent">
            <p>
                Who doesn’t love earning discounts and free items? With rewards, you'll gain access to awesome benefits
                such
                as discounts on groceries,
                rewards points with each dollar you spend, exclusive offers and bonus gifts. You’ll also receive weekly
                sale
                alerts,
                yummy recipes and hundreds of digital coupons to download to save instantly. And, to celebrate your
                birthday
                we will email you an awesome birthday surprise.
                We're thrilled you’re now part of our family.
            </p>


        </div>

        <div class="row alignButtons">
            <span><a href="#" class="btn btn-primary" style="width:150px; margin-right:5px;">Rewards</a></span>
            <span><a href="/about-rewards.php" class="btn btn-primary" style="width:150px; margin-right:5px;">About
                    Rewards</a></span>
            <span><a href="/account.php" class="btn btn-primary" style="width:150px; margin-right:5px;">Back To My
                    Account</a></span>
        </div>

    </div> <!-- end of class="box summary" div -->

    <div class="rewardPoints-summary">

        <div class="sectionHeader">
            <h1 style="color:#f79e1e;">Rewards Points</h1>
        </div>

    </div>
    <!-- end of rewardPoints-summary div -->

    <div class="row" id="rowRewardPoints">

        <div class="rewardPoints-1">

            <!-- <img id='<?php echo $imgId ?>' src='<?php echo $imgSrc ?>' alt='<?php echo $imgAlt ?>' style="width=100%; height:100%;"> -->

            <div class="myGradient" id="backgroundDiv">

                <?php 
                if ($rewardProgramType == "fuel")
                {
                ?>
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 472 777"
                    width="472" height="500" viewBox="0 0 60 55">
                    <defs>
                        <clipPath id="clip">
                            <!-- <rect class="clipRect" width="100%" x="0" y="100%" height="100%" /> -->
                            <rect class="clipRect" width="100%" x="0" y="<?php echo $percCompleteText ?>" height="100%">
                                <animate attributeName="y" from="100%" to="<?php echo $percCompleteText ?>" dur="2.5s"
                                    fill="freeze" />
                            </rect>
                        </clipPath>
                    </defs>
                    <path class="path-color" fill-rule="evenodd" clip-path="url(#clip)"
                        d="M202.5 0.74C206.35 1.03 212.88 2.12 217 3.18C221.13 4.23 227.43 6.64 231 8.53C234.57 10.41 240.18 14.1 243.45 16.73C246.73 19.35 251.59 24.2 254.26 27.5C256.93 30.8 260.66 36.65 262.56 40.5C264.46 44.35 266.96 51.32 268.13 56C269.88 63.03 270.16 66.48 269.76 76C269.39 84.7 268.64 89.45 266.66 95.5C265.23 99.9 262.35 106.42 260.28 110C258.2 113.57 252.9 120.11 248.5 124.51C244.1 128.92 238.36 133.65 231 137.5L231 159L255.75 159.02C273.69 159.03 282.43 159.44 287.5 160.51C291.35 161.32 297.43 163.43 301 165.2C304.96 167.15 309.84 170.77 313.5 174.45C316.8 177.78 320.94 183.2 322.69 186.5C324.45 189.8 326.58 195.42 327.43 199C328.68 204.27 328.97 212.82 329 283L334 283C338.27 283 338.93 282.74 338.55 281.25C338.3 280.29 336.42 275 334.37 269.5C330.93 260.27 330.63 258.66 330.57 248.5C330.51 239.14 330.82 236.9 332.61 233.5C333.78 231.3 336.93 227.56 339.61 225.2C343.07 222.15 347.56 219.71 355 216.84C360.77 214.6 365.73 212.6 366 212.38C366.27 212.16 365.22 208.05 363.65 203.24C362.09 198.43 358.94 190.9 356.65 186.51C354.27 181.91 349.95 175.81 346.5 172.16C343.2 168.66 338.25 164.31 335.5 162.5C332.75 160.68 327.57 157.95 324 156.43C320.43 154.91 317.16 153.4 316.74 153.08C316.33 152.76 318.44 146.87 321.45 140C324.72 132.5 327.53 127.4 328.45 127.25C329.3 127.11 334.39 129.13 339.75 131.74C345.11 134.35 352.09 138.4 355.25 140.74C358.41 143.08 363.54 147.59 366.63 150.75C369.73 153.91 373.95 158.97 376 162C378.05 165.02 381.31 170.65 383.24 174.5C385.17 178.35 387.87 184.65 389.25 188.5C390.62 192.35 392.56 199.1 393.55 203.5C394.54 207.9 395.91 212.17 396.58 213C397.25 213.82 401.55 222.37 406.13 232C413 246.44 414.44 250.29 414.34 254C414.25 257.37 411.46 264.8 403.27 283.5C397.25 297.25 391.58 309.96 390.66 311.75C389.75 313.54 387.64 315.79 382.98 318.5L382.99 331.75C382.99 339.04 383.49 349.39 384.08 354.75C384.67 360.11 386.03 368.77 387.09 374C388.16 379.22 390.21 387.55 391.65 392.5C393.1 397.45 396.63 407.35 399.5 414.5C402.37 421.65 407.42 432.9 410.73 439.5C414.04 446.1 421.03 458.92 426.26 468C431.5 477.07 439.24 490.35 443.47 497.5C447.69 504.65 453.57 515.45 456.52 521.5C459.47 527.55 463.28 536.33 464.99 541C466.7 545.67 468.98 553.89 470.05 559.25C471.41 566.03 472 573.11 472 582.5C472 590.9 471.4 598.93 470.41 603.75C469.54 608.01 467.73 614.65 466.39 618.5C465.04 622.35 462.04 628.85 459.72 632.95C457.23 637.35 452.43 643.49 448 647.95C443.88 652.1 437.57 657.2 434 659.28C430.43 661.35 423.9 664.19 419.5 665.59C414.5 667.17 407.94 668.34 402 668.7C396.44 669.04 388.97 668.78 384 668.06C379.32 667.39 370.89 665.3 355 660L355.01 668.75C355.02 676.09 354.62 678.31 352.53 682.5C351.06 685.44 348.51 688.53 346.34 690C343.43 691.96 341.17 692.55 329 693L329 702L350 702L350 728L395 728L395 777L0 777L0 728L46 728L46 702L66 702L66.5 201.5L68.86 195C70.16 191.42 72.75 186.14 74.61 183.25C76.47 180.36 79.91 176.16 82.25 173.91C84.59 171.67 88.53 168.55 91 166.99C93.47 165.43 98.42 163.12 102 161.86C108.1 159.71 110.26 159.55 165 159L165 138L160.75 135.62C158.41 134.3 154.03 131.24 151 128.8C147.97 126.37 143.41 121.7 140.85 118.44C138.29 115.17 134.38 108.67 132.15 104C129.92 99.32 127.4 92.01 126.55 87.75C125.7 83.49 125 76.85 125 73C125 69.15 125.71 62.51 126.58 58.25C127.45 53.99 129.86 46.9 131.93 42.5C134 38.1 137.9 31.61 140.6 28.07C143.29 24.53 148.2 19.44 151.5 16.76C154.8 14.08 161.1 10.14 165.5 8.02C169.9 5.89 175.53 3.62 178 2.97C180.47 2.32 185.43 1.44 189 1.01C192.57 0.58 198.65 0.46 202.5 0.74ZM354.87 394.5C354.58 400.78 353.85 404.69 352.47 407.45C351.27 409.87 348.75 412.5 346 414.22C342.3 416.53 340.38 417.03 335.25 417.01L329 417L329 592C339 592 342.33 592.67 345 594C347.26 595.13 350.19 597.82 351.75 600.18C354.19 603.89 354.53 605.43 354.75 613.68L355 623C364.3 627.65 371.16 630.43 376.25 632.19C384.27 634.95 386.9 635.38 396 635.44C405.86 635.5 406.91 635.3 413.25 632.25C417.17 630.36 421.93 627.01 424.59 624.25C427.12 621.64 430.65 616.58 432.44 613C434.23 609.42 436.49 602.9 437.48 598.5C438.85 592.35 439.16 587.72 438.8 578.5C438.4 568.12 437.86 565.08 434.79 556C432.84 550.23 429 541 426.25 535.5C423.5 530 415.66 516.05 408.82 504.5C401.98 492.95 393.06 477.43 389 470C384.94 462.57 379.41 451.77 376.71 446C374 440.23 370.1 431.23 368.03 426C365.97 420.77 363.24 413.35 361.97 409.5C360.7 405.65 358.68 398.68 357.48 394L355.29 385.5M359.37 230.77C354.9 232.27 350.22 234.4 348.98 235.5C347.74 236.6 346.11 238.96 345.36 240.75C344.61 242.54 344 245.46 343.99 247.25C343.98 249.04 344.71 252.97 345.6 256C346.48 259.02 349.64 267.01 352.6 273.75C355.57 280.49 358.45 286 359 286C359.55 286 360.23 284.99 360.52 283.75C360.8 282.51 363.51 270.02 366.53 256C369.56 241.97 372.02 229.94 372.01 229.25C372.01 228.56 370.99 228.01 369.75 228.02C368.51 228.03 363.84 229.27 359.37 230.77Z" />
                    <image class="svgImg" width="100%" height="100%" xlink:href=<?php echo $imgSrc ?> </image> </svg> <?php
                }
                else{
                ?> <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                        viewBox="0 0 511 736" width="511" height="500">
                        <defs>
                            <clipPath id="clip">
                                <!-- <rect class="clipRect" width="100%" x="0" y="100%" height="100%" /> -->
                                <rect class="clipRect" width="100%" x="0" y="<?php echo $percCompleteText ?>"
                                    height="100%">
                                    <animate attributeName="y" from="100%" to="<?php echo $percCompleteText ?>"
                                        dur="2.5s" fill="freeze" />
                                </rect>
                            </clipPath>
                        </defs>
                        <path class="path-color" fill-rule="evenodd" clip-path="url(#clip)"
                            d="M183.5 0.11C189.6 -0.03 190.78 0.24 192.69 2.22C194.53 4.14 195.45 8.15 198.48 27.5C200.47 40.15 201.49 55.91 203.18 62.5L207.66 54C211.69 46.36 212.48 43.67 215.45 27.5C217.27 17.6 219.03 8.82 219.36 8C219.68 7.18 221.09 5.94 222.48 5.25C224.05 4.47 229.43 3.99 236.75 3.97C247.51 3.93 248.74 4.12 251.37 6.22C254.07 8.37 254.2 8.82 253.65 14C253.33 17.02 252.77 25.8 252.41 33.5C251.91 44.18 252.15 49.99 253.4 58C254.3 63.78 256.34 73.45 257.93 79.5C259.53 85.55 262.68 95.67 264.94 102C267.2 108.33 269.44 114.17 269.91 115C270.65 116.3 271.12 116.23 273.36 114.5C274.78 113.4 276.16 111.83 276.43 111C276.69 110.17 280.64 105.87 285.2 101.44C291.58 95.24 295.56 92.36 302.43 88.94C310.78 84.79 311.98 84.48 320.93 84.12C328.7 83.8 331.72 84.13 337 85.85C340.57 87.01 345.52 89.25 348 90.81C350.48 92.37 354.92 96.32 357.87 99.58C361.18 103.23 364.89 108.95 367.54 114.5C369.91 119.45 372.59 126.88 373.5 131C374.41 135.13 375.36 139.63 375.61 141C375.88 142.48 376.4 143.09 376.89 142.5C377.34 141.95 383.88 125.53 391.42 106C398.97 86.47 406.33 68.47 407.77 66C409.22 63.53 413.15 58.8 416.5 55.5C420.04 52.02 425.31 48.16 429.05 46.31C432.6 44.56 437.52 42.66 440 42.09C442.48 41.52 447.2 41.05 450.5 41.04C453.8 41.04 459.43 41.66 463 42.42C466.57 43.18 473.55 45.56 478.5 47.71C483.45 49.86 490.31 53.5 493.75 55.81C497.19 58.11 501.59 62.14 503.53 64.75C505.48 67.36 507.82 71.75 508.73 74.5C509.83 77.8 510.37 82.56 510.31 88.5C510.26 93.45 509.48 100.88 508.57 105C507.67 109.13 505.54 117 503.84 122.5C502.15 128 498.18 139.25 495.03 147.5C491.88 155.75 485.58 171.5 481.05 182.5C476.51 193.5 472.18 203.18 471.43 204C470.67 204.82 470.04 206.63 470.03 208C470.02 209.38 469.11 212.19 468 214.25C466.9 216.31 465.99 218.79 465.98 219.75C465.97 220.71 466.54 222.07 467.23 222.77C467.93 223.46 469.29 224.03 470.25 224.02C471.21 224.01 475.04 220.64 478.75 216.53C484.48 210.18 485.99 209.05 488.75 209.03C491.03 209.01 492.45 209.67 493.51 211.25C494.84 213.24 495.01 239.03 495 433C494.99 577.83 494.63 655.56 493.95 661.5C493.38 666.45 491.55 674.55 489.87 679.5C488.2 684.45 484.98 691.65 482.71 695.5C480.44 699.35 475.41 705.82 471.54 709.88C467.67 713.94 461.8 719.08 458.5 721.31C455.2 723.54 449.35 726.85 445.5 728.68C441.65 730.5 434.45 732.92 429.5 734.04C420.6 736.06 418.6 736.08 78.5 735.5L69 732.2C63.78 730.38 56.58 727.17 53 725.06C49.42 722.94 44.02 719.18 41 716.69C37.98 714.21 33.18 709.32 30.35 705.84C27.51 702.35 23.38 696.13 21.16 692C18.94 687.88 15.85 680.45 11.5 666.5L11.26 439.5C11.04 225.19 11.13 212.4 12.76 210.72C13.72 209.74 15.63 208.93 17 208.93C18.8 208.93 21.52 211.03 26.75 216.47C30.74 220.61 34.79 223.99 35.75 223.98C36.71 223.97 38.5 222.95 41.96 219.5L28.98 206.75C21.49 199.4 13.98 190.93 11.23 186.75C8.55 182.67 5.23 175.78 3.65 171C1.55 164.67 0.82 160.46 0.77 154.5C0.74 150.1 1.28 144.03 1.97 141C2.66 137.97 4.54 132.8 6.13 129.5C7.73 126.2 11.39 120.39 14.27 116.59C17.15 112.79 21.98 107.94 25 105.81C28.02 103.68 32.75 101.22 35.5 100.34C38.98 99.22 42.97 98.84 56.74 99.5L57.29 88C57.59 81.67 58.56 73.8 59.45 70.5C60.35 67.2 62.46 61.58 64.14 58C65.95 54.18 69.54 49.1 72.85 45.67C76.64 41.76 80.96 38.63 85.95 36.17C93.32 32.53 93.51 32.5 105.95 32.5C115.79 32.5 119.8 32.93 124.5 34.49C127.8 35.58 133.1 38.05 136.27 39.99C139.45 41.92 144.77 46.2 148.1 49.5C152.29 53.65 155.36 57.96 158.07 63.5C160.22 67.9 161.98 71.05 161.98 70.5C161.98 69.95 162.22 71.33 158.99 55.25C156.67 43.7 155.44 38.84 153.51 28.25C150.27 10.48 150.12 8.77 151.5 6C152.32 4.35 154.01 2.76 155.25 2.47C156.49 2.17 161.78 1.56 167 1.11C172.22 0.65 179.65 0.2 183.5 0.11ZM161.73 96.23C160.66 101.2 160.7 101.95 162 101.96C162.82 101.97 164.06 101.64 164.74 101.23C165.73 100.65 165.7 98.64 164.6 91.5C163.66 85.35 163.19 83.77 163.1 86.5C163.03 88.7 162.41 93.08 161.73 96.23Z" />
                        <image class="svgImg" width="100%" height="100%" xlink:href=<?php echo $imgSrc ?> </image>
                            </svg> <?php   
                }
                ?> </div> </div> <!-- end of rewardPoints-1 div -->

                            <div class="rewardPoints-2">

                                <?php if ($rewardProgramType == "grocery") { ?>

                                <div class="grayBox" style="text-align:center;" id="groceryScoreCard">
                                    <p class="alignContent" style="font-size:20px;"> Available wallet credits:</p>

                                    <p><input type="text" name="txtWalletCredit" id="txtWalletCredit"
                                            value="$<?php echo number_format($userCredit['Balance'], 2); ?>  *"
                                            style="color:#f79e1e; text-align:center; font-weight:bold; font-size:40px; border:none; width:120px;">
                                        *
                                    </p>

                                    <!-- <p><h4><span class="walletEarned">$<?php echo number_format($userCredit['Balance'], 2); ?></span></h4></p> -->

                                    <p style="font-size:15px;">Points earned:
                                        <b> <input type="text" name="txtPointsEarned" id="txtPointsEarned"
                                                value="<?php echo !is_null($userPoints['Balance']) ? number_format($userPoints['Balance']) : 0; ?>"
                                                style="color:#fff; background-color:#f79e1e; text-align:center; font-size:20px; width:100px; font-weight:bold;">
                                        </b>
                                    </p>

                                    <!-- <p><span class="pointsTotal"><?php echo !is_null($userPoints['Balance']) ? number_format($userPoints['Balance']) : 0; ?> Points <br> Earned</span></p> -->

                                    <p class="alignContent"> Points needed for next reward: <span
                                            style="color:#f79e1e; font-size:20px; font-weight:bold;">
                                            <?php echo !is_null($earnedTotal) ? number_format($earnedTotal / 10) : 0; ?>
                                        </span> </p>

                                    <!-- <p><span class="pointsBanked"><b>$<?php echo !is_null($earnedTotal) ? number_format($earnedTotal / 10) : 0; ?> Earned</b><br><small>for next month</small></span></p> -->

                                    <p>* Valid for one time redemption only. <br> Wallet credits expire on the last day
                                        of the month.
                                    </p>

                                </div>

                                <?php } elseif ($rewardProgramType == "fuel") { ?>

                                <div class="grayBox" style="text-align:center;" id="fuelScoreCard">

                                    <p class="alignContent" style="font-size:20px;"> Available fuel savings:</p>

                                    <p><input type="text" name="txtWalletCredit" id="txtWalletCredit"
                                            value="$<?php echo !is_null($availableCentsPerGallonReward) ? number_format($availableCentsPerGallonReward, 2) : 0; ?>/gallon"
                                            style="color:#f79e1e; text-align:center; font-weight:bold; font-size:30px; border:none;">
                                    </p>
                                    <!-- $availableCentsPerGallonReward -->

                                    <p style="font-size:15px;">Current fuel points: <b> <input type="text"
                                                name="txtPointsEarned" id="txtPointsEarned"
                                                value="<?php echo !is_null($userPoints['Balance']) ? number_format($userPoints['Balance']) : 0; ?>"
                                                style="color:#fff; background-color:#f79e1e; text-align:center; font-size:20px; width:50px; font-weight:bold;">
                                        </b>
                                    </p>

                                    <!-- <p><span class="pointsTotal"><?php echo !is_null($userPoints['Balance']) ? number_format($userPoints['Balance']) : 0; ?> Points <br> Earned</span></p> -->

                                    <p class="alignContent"> Available wallet credit: <span
                                            style="color:#f79e1e; font-size:25px; font-weight:bold;">
                                            $<?php echo number_format($userCredit['Balance'], 2); ?>
                                        </span> <br> <br> </p>

                                    <!-- <p><h4><span class="walletEarned">$<?php echo number_format($userCredit['Balance'], 2); ?></span></h4></p> -->

                                    <p>* One time redemption only. Points will accrue throughout the month but cease
                                        once redeemed and
                                        will resume with the
                                        onset of the new month.
                                    </p>

                                </div>

                                <?php } ?>

                            </div>

                            <!-- end of rewardPoints-2 div -->

            </div>

            <div class="box rewardOffers-summary">

                <div class="row">
                    <h1 style="color:#f79e1e;">Level Up with Rewards </h1>
                </div>

            </div> <!-- end of rewardPoints-summary div -->

            <div class="row" id="levelUpContentRow">
                <p>
                    We’ve partnered with many of the brands you know and love to offer you special savings on the
                    products
                    you
                    frequently buy.
                    We are offering you free items or bonus savings after you’ve bought a certain number of those
                    products.
                    Level up today, shop these special buys
                    and earn free product.
                </p>
            </div>



            <?php
if(isset($personalOffers))
{
    $rowCounter = 0;
    foreach($personalOffers as $offer) {

    
    $rowCounter++;
?>

            <div>

                <div id="offersRow1" class="parentOffers">
                    <div>
                        <h4 style="color:#71BF0C;">
                            <?php echo $offer->headline; ?>
                        </h4>
                    </div>

                    <div
                        style="color:#71BF0C; font-weight:bold; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 16.25px;">
                        <?php
                            if($offer->percentComplete == '100'){
                          ?>
                        <span class="redeemNow" style="color:#71BF0C;">Redeem Now</span>
                        <?php
                            }else{
                          ?>
                        <span
                            style="color:#71BF0C; font-weight:bold; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size:16.25px;">
                            <?php echo $offer->percentComplete; ?>%
                        </span>
                        <?php
            }
            ?>
                    </div>

                </div>

                <div id="offersRow2" class="parentOffers">

                    <!--  <div class="progress">
                        <div class="bar <?php echo $offer->percentComplete == '100' ? 'bar-success' : 'bar-primary'; ?>"
                            style="background-color:green; width: <?php echo $offer->percentComplete; ?>%;"></div>
                    </div> -->

                    <div class="<?php echo $offer->percentComplete == '100' ? 'bar-success' : 'bar-primary'; ?>"
                        style="width:<?php echo $offer->percentComplete ?>%;"></div>


                </div>

                <div id="offersRow3" class="parentOffers">

                    <div>
                        <?php echo $offer->description; ?>
                    </div>

                    <div>
                        exp. <?php echo $offer->expires; ?>
                    </div>

                </div>

                <div id="offersRow4" class="parentOffers">

                    <div id="allLearnMore" class="accordion">

                        <div class="accordion" id="allLearnMore">
                            <div class="accordion-group">
                                <!--   <div class="accordion-heading">
                        <h3>
                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#allLearnMore"
                                style="color:#f79e1e; href=" #collapse_LearnMore">                                   
                            </a>
                        </h3>
                    </div> -->
                                <div id="collapse_LearnMore" class="accordion-body collapse in">
                                    <div class="accordion-inner">
                                        <div id="group_LearnMore" class="accordion">
                                            <div class="accordion-group">
                                                <div class="accordion-heading">
                                                    <a class="accordion-toggle" data-toggle="collapse"
                                                        data-parent="#group_LearnMore"
                                                        href="#learn-more-<?php echo $rowCounter ?>">
                                                        <h4 id="headerLearnMore">Learn More </h4>
                                                    </a>
                                                </div>

                                                <div id="learn-more-<?php echo $rowCounter ?>"
                                                    class="accordion-body collapse">
                                                    <div class="accordion-inner" style="text-align: left;">

                                                        <?php echo $offer->limit; ?> <br>
                                                        <?php echo $offer->restrictions; ?>

                                                    </div>

                                                </div>

                                            </div>
                                            <!--- end of group_LearnMore section -->
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <hr>
                    </div>

                </div> <!-- id="offersRow4" class="parentOffers" -->

                <?php
    }       //end of foreach($personalOffers as $offer)
} else {
  ?>
                <h4 id="noOffers">No offers available</h4>

                <?php
    }
    ?>

            </div>








            <div class="row instantSavings-summary">
                <h1 id="instantSavingsHeader" style="color:#f79e1e;">Instant Savings</h1>
            </div>
            <div class="row instantSavings-summary">
                <p id="summaryInstantSavings">
                    Unlike digital coupons where you need to clip them to your account, we want to say thank you with
                    these
                    great deals just for being a rewards member.
                    Our instant savings offers are loaded automatically to your account to make is easy for you to save
                    money at
                    the checkout or when shopping online.
                </p>

            </div>

            <div class="parentCoupons">

                <div id="couponsRow1">
                    <div class="ml-0 mb-30 clearfix" id="allCouponsContainer">

                        <div class="span71 ml-0">

                            <?php
                     
                      
                        if(!is_null($commonOffers)){
                          foreach($commonOffers as $coupon){
                            
                            ?>
                            <div class="oneCoupon" id="coupon_<?php echo $coupon->id; ?>"
                                data-restrictions="<?php echo !is_null($coupon->restrictions) ? $coupon->restrictions : "No restrictions"; ?>"
                                data-expires="<?php echo $coupon->expires; ?>"
                                data-expiressort="<?php echo $coupon->expiresSort; ?>">
                                <i class="icon-question-sign tooltip" data-toggle="tooltip" data-placement="bottom"
                                    title="" data-original-title="Click for more information"
                                    data-container="#coupon_<?php echo $coupon->id; ?>"></i>


                                <div class="imageContain">
                                    <?php
                                if(!is_null($coupon->image)){
                              ?>
                                    <img src="<?php echo $coupon->image; ?>" class="couponImage"
                                        alt="<?php echo $coupon->product; ?>" width="100%">
                                    <?php
                                }else{
                              ?>
                                    &nbsp;
                                    <?php
                                }
                              ?>
                                </div>

                                <div class="couponInformation">
                                    <div class="couponContent">
                                        <h4 class="couponHeadline"><?php echo $coupon->offer; ?></h4>
                                        <p class="couponDescription"
                                            data-full-description="<?php echo $coupon->description; ?>">
                                            <?php echo $coupon->shortDesc; ?>
                                            <br>
                                            <?php echo $coupon->expires; ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                      }else{
                    ?>
                            <h4 id="noCoupons">No coupons available</h4>
                            <?php
                      }

                      if($rewardsUserObj->error !== false){
                    ?>
                            <p class="hideObject" id="rewardsErrorMsg"><?php echo $rewardsUserObj->error; ?></p>
                            <?php
                      }
                    ?>
                        </div>
                    </div>

                    <div id="couponModal" class="modal hide fade" tabindex="-1" role="dialog"
                        aria-labelledby="couponModalLabel" aria-hidden="true">
                        <div class="coupon-modal-body">
                            <div class="oneCouponModal">
                                <div class="imageContainModal">
                                    <img src="" class="couponImage" width="100%">
                                </div>

                                <div class="couponInformationModal">
                                    <div class="couponContentModal">
                                        <h4 class="couponOffer couponClear"></h4>
                                        <p class="couponDescription couponClear"></p>
                                        <h6 class="restrictionsModal">Restrictions:</h6>
                                        <p class="couponRestrictions couponClear"></p>
                                        <h6>Expires:</h6>
                                        <p class="couponExpires couponClear"></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
                        </div>
                    </div>

                </div>
                <?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>

            </div>



        </div>



    </div>



    <!-- <div class="myGradient">

</div> -->

</div> <!-- end of wrapper div -->

<div style="clear: both; margin-bottom: 60px;"></div>

<script type="text/javascript">
$(document).ready(function() {
    $(".tooltip").tooltip();

    $(".accordion-heading a").on('click', function() {
        $(".accordion-heading").removeClass("viewed");
        var $this = $(this);
        var $aHeading = $this.parents(".accordion-heading");
        setTimeout(function() {
            if ($aHeading.siblings(".accordion-body").is(".in")) {
                $aHeading.addClass("viewed");
            }
        }, 50);
    });

    $(".charityOption").on('touch click', function() {
        $("#updateCharityBtn").removeClass("hideObject");
        $('html, body').animate({
            scrollTop: $("#updateCharityBtn").offset().top - 100
        }, 2000);
    });

    $("#updateCharityBtn").on('touch click', function(e) {
        e.preventDefault();

        var id = $('input[type=radio][name=charityradios]:checked').attr('id').replace("charityradios-",
            "");

        $.ajax({
            type: "POST",
            url: "/admin/lookUp.php",
            data: "action=changeBrCharity&charity=" + id,
            dataType: "json",
            success: function(theResponse) {
                if (theResponse.success === true) {
                    var schoolName = theResponse.charity.Description.split("_")[0];
                    $("#charitySuccess").removeClass("hideObject");
                    $("#charityName").text(schoolName);

                    $('html, body').animate({
                        scrollTop: $("#charityChangeContain").offset().top
                    }, 2000);

                    setTimeout(function() {
                        $("#charitySuccess").addClass("hideObject");
                    }, 5000);
                }
            }
        });
    });

    $("body").on("click touch", "#walletCreditsContainer .icon-question-sign", function(e) {
        e.preventDefault();

        $("#pointsModal").modal("show");
    });

    $("body").on("click touch", "#allCouponsContainer .oneCoupon .icon-question-sign", function(e) {
        e.preventDefault();
        var $this = $(this).closest('.oneCoupon');

        $("#couponModal .couponImage").attr("src", $this.find(".couponImage").attr("src"));
        $("#couponModal .couponOffer").html($this.find(".couponContent .couponHeadline").html());
        $("#couponModal .couponDescription").html($this.find(".couponContent .couponDescription").data(
            "full-description"));
        $("#couponModal .couponRestrictions").html($this.data("restrictions"));
        $("#couponModal .couponExpires").html($this.data("expires"));

        $("#couponModal").modal("show");
    });

    $("#couponModal").on('hidden.bs.modal', function() {
        $this = $(this);
        $(".couponImage", $this).attr("src", "");
        $(".couponClear").html("");
    })

    /* 		$(".learnMoreReveal").on("click touch", function(e){
    		  e.preventDefault();
    		  $(this).closest(".oneOffer").find(".offerDescriptionFull").toggleClass("hideObject");
    		}); */

    var maxHeight = -1;
    $('.sameSize1').each(function() {
        maxHeight = maxHeight > $(this).height() ? maxHeight : $(this).height();
    });

    $('.sameSize1').height(maxHeight);

    $("#couponsSort").on("change", function() {
        var direction = $("option:selected", this).val();

        var divList = $("#allCouponsContainer .oneCoupon");
        if (direction === "old") {
            divList.sort(function(a, b) {
                return $(b).data("expiressort") - $(a).data("expiressort");
            });
        } else {
            divList.sort(function(a, b) {
                return $(a).data("expiressort") - $(b).data("expiressort");
            });
        }

        $("#allCouponsContainer").html(divList);
    });

        //Receipts Code
        
		/* $(".receiptLink").on("touch click", function(e){
		  e.preventDefault();
		  
		  var id = $(this).closest('.receiptLinkContainer').attr('id').replace('receiptLink_', '');
		  $("#rewardsContentContainer .oneReceipt").addClass("hideObject");
		  $("#fullReceipt_" + id).removeClass("hideObject");
		}); */

    $("#charityTable").DataTable({
        "order": [
            [2, "asc"]
        ],
        paging: false
    });
});
</script>

<script type="text/javascript">
/* var divHeight = findGetParameter('complete')
var bgDiv = document.querySelector('.myGradient') */

function findGetParameter(parameterName) {
    var result = null,
        tmp = [];
    var items = location.search.substr(1).split("&");
    for (var index = 0; index < items.length; index++) {
        tmp = items[index].split("=");
        if (tmp[0] === parameterName) result = decodeURIComponent(tmp[1]);
    }
    return result;
}

/* function setBgDivProperties(){
    var heightParamValue = findGetParameter('complete')
    

    var bgDiv = document.querySelector('.myGradient')
    var divHeight =  heightParamValue

    bgDiv.style.setProperty('--bgDiv-color', '#f79e1e')
    bgDiv.style.setProperty('--bgDiv-height', divHeight + "%")
    // document.getElementById('backgroundDiv').style.height = 500px * (heightParamValue/100);
} */

function setBgDivProperties() {
    var imgIdValue = document.getElementsByTagName("img")[1];
    // var getIdPosition = String(imgIdValue).search("#");

    // var imageNameLength = String(imgIdValue).length;
    // var imageName = String(imgIdValue).substr(4, imageNameLength);
    // var imageName = String(imgIdValue['id']);

    /*   var imageNameLength = String(imgIdValue).length;
      var imageName = String(imgIdValue).substr(4, imageNameLength); */

    // var img = document.getElementById(imageName);
    /* 
        var imgWidth = String(imgIdValue['width']);
        var imgHeight = String(imgIdValue['height']);

        var elem = document.getElementById('backgroundDiv');
        document.documentElement.style.setProperty('--bgDiv-width', parseInt(imgWidth));
        var bgDivWidth = elem.style.width; */

    var heightParamValue = findGetParameter('complete');
    // document.querySelector('.clipRect').style.y = heightParamValue + '%';
    // document.querySelector('.clipRect').style.backgroundcolor = '#f79e1e';
    // elem.style.background = 'linear-gradient(to bottom, transparent ' + heightParamValue + '%, #f79e1e 10%)';
}

// setBgDivProperties();
</script>